# Репозиторий проекта
Приложение GyverHub может работать с GitHub репозиторием вашего проекта, оформленного по особым правилам. Это взаимодействие позволяет:
- Обновлять прошивку устройства "по воздуху" файлом из репозитория при выходе новых версий
- Прошивать устройство по USB файлом из репозитория
- Добавить свой проект в публичную базу проектов на основе GyverHub (вкладка **Проекты** снизу в приложении)

Нужно зарегистрироваться на GitHub, создать репозиторий и загрузить в него файлы (см. гугл). GyverHub требует наличия файла информации `project.json`. [Пример оформления проекта](https://github.com/GyverLibs/GyverHub-example).

## project.json
Файл содержит информацию о проекте и пути к файлам скомпилированной прошивки для разных платформ:
```json
{
  "name": "Название проекта",
  "about": "Краткое описание проекта",
  "version": "1.0",
  "notes": "Комментарии к обновлению",
  "builds": [
    {
      "chipFamily": "ESP8266",
      "parts": [
        {
          "path": "https://raw.githubusercontent.com/GyverLibs/GyverHub-example/main/bin/firmware.bin",
          "offset": 0
        }
      ]
    }
  ]
}
```

### Массив builds
Если проект может быть запущен на разных ESP-шках - можно приложить отдельный бинарник для каждой и указать пути к ним. Полный пример со всем семейством ESP можно посмотреть [тут](https://raw.githubusercontent.com/GyverLibs/GyverHub-example/main/project.json). 

### Параметр chipFamily
Поддерживаемые платформы и значения параметра `chipFamily`:
- `ESP8266`
- `ESP32`
- `ESP32-C3`
- `ESP32-S2`
- `ESP32-S3`

### Путь path
Путь должен вести к скомпилированному файлу прошивки. Его можно разместить как в самом репозитории, так и в релизах:

#### В репозитории
```
https://raw.githubusercontent.com/<аккаунт>/<проект>/main/<путь от корня репозитория>
```
Примеры:
- bin
  - firmware.bin
  - esp8266
    - firmware.bin
  - esp32
    - firmware.bin
```
https://raw.githubusercontent.com/GyverLibs/GyverHub-example/main/bin/firmware.bin
https://raw.githubusercontent.com/GyverLibs/GyverHub-example/main/bin/esp8266/firmware.bin
https://raw.githubusercontent.com/GyverLibs/GyverHub-example/main/bin/esp32/firmware.bin
```

#### В релизах
```
https://github.com/<аккаунт>/<проект>/releases/latest/download/<файл>
```
Пример:
```
https://github.com/GyverLibs/GyverHub-example/releases/latest/download/firmware.bin
```

## Добавление проекта в базу
### Публично
Чтобы проект был доступен всем - [читай инструкцию](https://github.com/GyverLibs/GyverHub-projects/)

### Индивидуально
TODO

## Прошивка через USB
Если проект отображается на вкладке **Проекты** - его можно загрузить в устройство по USB. Это можно сделать с HTTPS версии сайта, нужно кликнуть на значок загрузки около названия проекта и следовать инструкциям.

## OTA обновление
### Указание версии
Чтобы приложение знало, что для устройства нужно искать обновление, нужно установить текущую версию проекта в прошивке при помощи функции `setVersion()` следующим образом: `hub.setVersion("аккаунт/репозиторий@версия")`, например `"AlexGyver/TachoLED@1.0"`

### Обновление репо
- Обновить код версии в `.setVersion()` в прошивке
- Скомпилировать и загрузить в репозиторий свежий бинарник
- Обновить код версии в `project.json`

### Запуск OTA
При входе на устройство в приложении автоматически проверяются обновления. Если доступна новая версия - появится всплывающее окно с предложением обновиться. Отключить автоматические обновления можно в настройках приложения.