#include <FastLED.h>

//--------------------------------------------------------
template<typename TI, typename TU>
void send_console(TI T_ip, TU T_udp)
{
  IPAddress lamp(192,168,100,1);
  FOR_i(0,4) {
    String byte_str=getValue(String(T_ip),'.',i);
    lamp[i]=byte_str.toInt();
  }
    char send_udp[MAX_UDP_BUFFER_SIZE];
    String st=String(T_udp);
    strcpy(send_udp,st.c_str()); 

    Udp.beginPacket(lamp, ESP_UDP_PORT);
    delay(10);
    Udp.print(send_udp);
    Udp.endPacket();
    parseUDP();
}
//--------------------------------------------------------
String getValue(String data, char separator, int index)
{
    data.replace("\0"," ");
    data.trim();
    int found = 0;
    int strIndex[] = {0, -1};
    int maxIndex = data.length()-1;
    for(int i=0; i<=maxIndex && found<=index; i++){
      if(data.charAt(i)==separator || i==maxIndex){
          found++;
          strIndex[0] = strIndex[1]+1;
          strIndex[1] = (i == maxIndex) ? i+1 : i;
      }
    }
    return found>index ? data.substring(strIndex[0], strIndex[1]) : "";
}
//--------------------------------------------------------
void parseUDP()
{
  int32_t packetSize = Udp.parsePacket();

  if (packetSize)
  {
    int16_t n = Udp.read(packetBuffer, MAX_UDP_BUFFER_SIZE);
    packetBuffer[n] = '\0';
    strcpy(inputBuffer, packetBuffer);
    if (Udp.remoteIP() == WiFi.localIP()) return;  // не реагировать на свои же пакеты
    String strBuffer=String(inputBuffer);
    String strCommand=getValue(strBuffer,';',0);
    IPAddress lamp=Udp.remoteIP();
    String str_ip_l=String(lamp[0])+"."+String(lamp[1])+"."+String(lamp[2])+"."+String(lamp[3]);
    //DEBUGLN(inputBuffer);
    //----------------------------------
    if (strCommand=="DISCOVER") {
       Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
       char send_udp[50];
       sprintf_P(send_udp, (const char *)F(DISCOVER), WiFi.localIP()[0], WiFi.localIP()[1], WiFi.localIP()[2], WiFi.localIP()[3], ESP_UDP_PORT);
       DEBUGLN(send_udp);
       Udp.print(send_udp);
       Udp.endPacket();
    }
    //----------------------------------
    if (!strncmp_P(inputBuffer, PSTR("GET"), 3)) reply_GET_UDP();
    //----------------------------------
    if (strCommand=="LOAD") module_load();
    //----------------------------------
    module_parsig(255,inputBuffer);
    //----------------------------------
    if (strCommand=="SETIP") {
       String byte_str=getValue(strBuffer,';',1);
       int i = byte_str.toInt();
       ip_addr[i].on_off=(getValue(strBuffer,';',2)=="1");
       if (i<MAX_IP) {
          String argBuffer=getValue(strBuffer,';',3);
          strcpy(ip_addr[i].ipchr,argBuffer.c_str());
          argBuffer=getValue(strBuffer,';',4); // 
          FOR_j(0,16) {
           if (argBuffer[j]=='1') ip_addr[i].copy_attr.set(j);
              else ip_addr[i].copy_attr.clear(j);
          }
          argBuffer=getValue(strBuffer,';',5); // 
          ip_addr[i].col.setHEX(strtoul(argBuffer.c_str(), 0, 16));
          if (ip_addr[i].col==0) ip_addr[i].col.setHEX(0x077777);
          FS_UPDATE(ip_addr);
       }
    }
  //--------------------------------------------------------------------         
    FOR_i(0,MAX_IP) if (ip_addr[i].on_off) {
      if (String(ip_addr[i].ipchr) == str_ip_l) {
         lamp_status[i].last_input_udp=millis();
         lamp_status[i].online=true;
   //--------------------------------------------------------------------
   // ответ на GET
         if (getValue(strBuffer,' ',0)=="CURR") { 
            if (getValue(strBuffer,' ',5)=="1") lamp_status[i].on_off=true;
            else lamp_status[i].on_off=false;  
         String byte_str=getValue(strBuffer,' ',1);
         lamp_status[i].eff=byte_str.toInt();
         byte_str=getValue(strBuffer,' ',2);
         lamp_status[i].BRI=byte_str.toInt();
         byte_str=getValue(strBuffer,' ',3);
         lamp_status[i].SPD=byte_str.toInt();
         byte_str=getValue(strBuffer,' ',4);
         lamp_status[i].SCA=byte_str.toInt();
         byte_str=getValue(strBuffer,' ',1);
         if (i==0) effect=byte_str.toInt();
         }
   //--------------------------------------------------------------------         
   // ответ на DICOVER
         if (getValue(String(inputBuffer),' ',0)=="IP") { 
            String str = getValue(String(inputBuffer),' ',1);
            lamp_status[i].name = getValue(str,':',2);
         }


//--------------------------------------------------------------------         
       }
      if (millis()-lamp_status[i].last_input_udp>60000)
         lamp_status[i].online=false;
      if (HUB_Update && hub.focused()) {
         hub.sendUpdate("led_on"+String(i), String(lamp_status[i].on_off));
         hub.sendUpdate("led"+String(i), String(lamp_status[i].online));
         HUB_Update=false;
       }    
    }
  }
}
  
//----------------------------------
void Get_Name() {
  static uint8_t i=0;
  if (ip_addr[i].on_off)
    if (lamp_status[i].name=="")
       send_console(ip_addr[i].ipchr,(char *)F("DISCOVER"));
  i++;
  if (i>=MAX_IP) i=0;
}

//----------------------------------
void reply_GET_UDP() {
   Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
   char send_udp[50];
   uint8_t curr_power=0;
   uint8_t curr_bri=0;
   uint8_t curr_eff=0;
    #if defined (PWM_PIN)
      curr_bri=signal_pwm[0]/4;
      curr_power = (curr_bri>0) ? 1:0;
    #endif
    #if defined (RELE_PIN)
      curr_power = rele[0];
    #endif
    #if defined (WS2812_PIN)
      curr_eff = Real_EFF;
      curr_bri=BRI;
    #endif
   sprintf_P(send_udp, (const char *)F("CURR %d %d 0 0 %d 0 0 0 0 %d:%d:00 0"), curr_eff, curr_bri, curr_power, hour, minute);
   Udp.printf(send_udp);
   Udp.endPacket();
   module_get();
}

//----------------------------------
int32_t str_to_int(String str) {
// DEBUGLN("str='"+str+"'");
// str=" "+str;
 if (str=="") return 0;
 if (str==" ") return 0;
 if (str=="+") return 0;
 if (str=="-") return 0;
 if (str=="*") return 0;
 if (str=="/") return 0;
 if (str=="%") return 0;
 if (str==">") return 0;
 if (str=="<") return 0;
 if (str=="=") return 0;
 str.replace("==", "="); 
// Сложение / Вычитание
 if (str.indexOf("+") !=-1) {
//    DEBUGLN("str1='"+getValue(str,'+',0)+"'");
//    DEBUGLN("str2='"+str.substring(str.indexOf("+")+1)+"'");
    return str_to_int(getValue(str,'+',0))+str_to_int(str.substring(str.indexOf("+")+1));
 }
 if (str.lastIndexOf("-") !=-1)
    return str_to_int(str.substring(0,str.lastIndexOf("-")))-str_to_int(str.substring(str.lastIndexOf("-")+1));
// Умножение / деление / остаток
 if (str.indexOf("*") !=-1)
    return str_to_int(getValue(str,'*',0))*str_to_int(str.substring(str.indexOf("*")+1));
 if (str.lastIndexOf("/") !=-1) {
    if (str_to_int(str.substring(str.lastIndexOf("/")+1))==0) return 0;
    return str_to_int(str.substring(0,str.lastIndexOf("-")))/str_to_int(str.substring(str.lastIndexOf("/")+1));
    }
 if (str.indexOf("%") !=-1) {
    if (str_to_int(str.substring(str.indexOf("/")+1))==0) return 0;
    return str_to_int(getValue(str,'%',0))%str_to_int(str.substring(str.indexOf("%")+1));
    }
// Сравнение 
 if (str.indexOf(">") !=-1)
    return str_to_int(getValue(str,'>',0))>str_to_int(str.substring(str.indexOf(">")+1));
 if (str.indexOf("<") !=-1)
    return str_to_int(getValue(str,'<',0))<str_to_int(str.substring(str.indexOf("<")+1));
 if (str.indexOf("=") !=-1)
    return str_to_int(getValue(str,'=',0))==str_to_int(str.substring(str.indexOf("=")+1));

 if (str == "HH") return hour;
 if (str == "MM") return minute;
 if (str == "DY") return dayofweek;
 if (getValue(str,',',0) == "RND") {
   String rnd_str_from=getValue(str,',',1);
   String rnd_str_to=getValue(str,',',2);
   int16_t rnd_from=str_to_int(rnd_str_from);
   DEBUGLN("RND:"+rnd_str_from);
   if (rnd_str_to.length()) return  random8(rnd_from,str_to_int(rnd_str_to));
   else return  random8(rnd_from);
 }
 if (str == "ON_OFF") return ON_OFF;
// Модули 
#if defined (DHT_PIN)
 if (str == "H") return humidity;
 if (str == "T") return temperature;
#endif
#if defined (WS2812_PIN)
 if (str == "EFF") return Real_EFF;
 if (str == "BRI") return BRI;
 if (str == "SPD") return SPD;
 if (str == "SCA") return SCA;
 if (str == "CLR") return CLR;
#endif
#if defined (DFPlayer)
 if (str == "VOL") return mp3_volume;
#endif
#if defined (SR501_PIN)
 if (str == "SR501") return int(sr501_s);
#endif
#if defined (PWM_PIN)
 if (str == "PWM") return signal_pwm[0]; 
 FOR_i(0,PWM_PIN) if (str == "PWM"+String(i)) return signal_pwm[i];
#endif

 return str.toInt();
}
//----------------------------------
