#if defined (WS2812_PIN)
#if (WS2812_D==1)  // Лента, Кольцо

#include <FastLED.h>

#define NUM_LEDS    16 // Количество светодиодов в кольце

#define MAX_EFF     20 //Количество эффектов

#define NAME_EFF   "Ночник;Цветоворот;Радуга;Круговорот;Облака;Лава;Плазма;Хаос;Павлин;Лес;Океан;Апельсин;Огонь;\
Пламя;\
Lithium;\
Лимон;\
Трава;\
Небо;\
Рубидий;\
Калий;\
Зебра;\
Цвет"



uint16_t speed = 20;     // speed is set dynamically once we've started up
uint16_t scale = 30;     // scale is set dynamically once we've started up

uint8_t colorLoop = 1;
uint8_t hue = 0;
uint8_t rassvet=0;
uint8_t length_rassvet = 10; // 10 минут

uint8_t noise[NUM_LEDS];

extern const TProgmemRGBPalette16 WaterfallColors_p FL_PROGMEM = {0x000000, 0x060707, 0x101110, 0x151717, 0x1C1D22, 0x242A28, 0x363B3A, 0x313634, 0x505552, 0x6B6C70, 0x98A4A1, 0xC1C2C1, 0xCACECF, 0xCDDEDD, 0xDEDFE0, 0xB2BAB9};
extern const TProgmemRGBPalette16 WoodFireColors_p FL_PROGMEM = {CRGB::Black, 0x330e00, 0x661c00, 0x992900, 0xcc3700, CRGB::OrangeRed, 0xff5800, 0xff6b00, 0xff7f00, 0xff9200, CRGB::Orange, 0xffaf00, 0xffb900, 0xffc300, 0xffcd00, CRGB::Gold};             //* Orange
extern const TProgmemRGBPalette16 NormalFire_p FL_PROGMEM = {CRGB::Black, 0x330000, 0x660000, 0x990000, 0xcc0000, CRGB::Red, 0xff0c00, 0xff1800, 0xff2400, 0xff3000, 0xff3c00, 0xff4800, 0xff5400, 0xff6000, 0xff6c00, 0xff7800};                             // пытаюсь сделать что-то более приличное
extern const TProgmemRGBPalette16 NormalFire2_p FL_PROGMEM = {CRGB::Black, 0x560000, 0x6b0000, 0x820000, 0x9a0011, CRGB::FireBrick, 0xc22520, 0xd12a1c, 0xe12f17, 0xf0350f, 0xff3c00, 0xff6400, 0xff8300, 0xffa000, 0xffba00, 0xffd400};                      // пытаюсь сделать что-то более приличное
extern const TProgmemRGBPalette16 LithiumFireColors_p FL_PROGMEM = {CRGB::Black, 0x240707, 0x470e0e, 0x6b1414, 0x8e1b1b, CRGB::FireBrick, 0xc14244, 0xd16166, 0xe08187, 0xf0a0a9, CRGB::Pink, 0xff9ec0, 0xff7bb5, 0xff59a9, 0xff369e, CRGB::DeepPink};        //* Red
extern const TProgmemRGBPalette16 SodiumFireColors_p FL_PROGMEM = {CRGB::Black, 0x332100, 0x664200, 0x996300, 0xcc8400, CRGB::Orange, 0xffaf00, 0xffb900, 0xffc300, 0xffcd00, CRGB::Gold, 0xf8cd06, 0xf0c30d, 0xe9b913, 0xe1af1a, CRGB::Goldenrod};           //* Yellow
extern const TProgmemRGBPalette16 GrassFireColors_p FL_PROGMEM = {CRGB::Black, 0x001a00, 0x003300, 0x004d00, 0x006600, CRGB::Green, 0x239909, 0x45b313, 0x68cc1c, 0x8ae626, CRGB::GreenYellow, 0x94f530, 0x7ceb30, 0x63e131, 0x4bd731, CRGB::LimeGreen};     //* Green
extern const TProgmemRGBPalette16 SkyFireColors_p FL_PROGMEM = {CRGB::Black, 0x000033, 0x000066, 0x000099, 0x0000cc, CRGB::Blue, 0x0026ff, 0x004cff, 0x0073ff, 0x0099ff, CRGB::DeepSkyBlue, 0x1bc2fe, 0x36c5fd, 0x51c8fc, 0x6ccbfb, CRGB::LightSkyBlue};  //* Blue
extern const TProgmemRGBPalette16 RubidiumFireColors_p FL_PROGMEM = {CRGB::Black, 0x0f001a, 0x1e0034, 0x2d004e, 0x3c0068, CRGB::Indigo, CRGB::Indigo, CRGB::Indigo, CRGB::Indigo, CRGB::Indigo, CRGB::Indigo, 0x3c0084, 0x2d0086, 0x1e0087, 0x0f0089, CRGB::DarkBlue};        //* Indigo
extern const TProgmemRGBPalette16 PotassiumFireColors_p FL_PROGMEM = {CRGB::Black, 0x0f001a, 0x1e0034, 0x2d004e, 0x3c0068, CRGB::Indigo, 0x591694, 0x682da6, 0x7643b7, 0x855ac9, CRGB::MediumPurple, 0xa95ecd, 0xbe4bbe, 0xd439b0, 0xe926a1, CRGB::DeepPink}; //* Violet
extern const TProgmemRGBPalette16 ZebraColors_p FL_PROGMEM = {CRGB::White, CRGB::Black, CRGB::Black, CRGB::Black, CRGB::White, CRGB::Black, CRGB::Black, CRGB::Black, CRGB::White, CRGB::Black, CRGB::Black, CRGB::Black, CRGB::White, CRGB::Black, CRGB::Black, CRGB::Black,}; //* Zebra

/*
const TProgmemRGBPalette16 *palette_arr[] = {
  &PartyColors_p,
  &OceanColors_p,
  &LavaColors_p,
  &HeatColors_p,
  &WaterfallColors_p,
  &CloudColors_p,
  &ForestColors_p,
  &RainbowColors_p,
  &RainbowStripeColors_p
};

//const TProgmemRGBPalette16 *curPalette = palette_arr[0];
*/
CRGBPalette16 currentPalette(PartyColors_p);

uint8_t Real_EFF = 0;
uint8_t BRI=128;
uint8_t SPD=128;
uint8_t SCA=128;
uint8_t CLR=0;

uint8_t old_Real_EFF = 0;
uint8_t old_BRI=10;
uint8_t old_SPD=128;
uint8_t old_SCA=128;
uint8_t old_CLR=0;

CRGB leds[NUM_LEDS];  // создаём кольцо


//--------------------------------------------------------
struct struct_WS2812{
  bool on_off;
  char cmd[15];
  uint8_t BRI;
  uint8_t SPD;
  uint8_t SCA;
  bool ok=true;
};
struct_WS2812 WS2812_R[MAX_EFF];
FS_(WS2812_R);
//--------------------------------------------------------
void setup_WS2812(){
  FS_LOAD(WS2812_R); 
  FastLED.addLeds<WS2811, WS2812_PIN, COLOR_ORDER>(leds, NUM_LEDS);  // инициализация светодиодов (RGB,BRG - порядок цветов) 
  main_menu+=WS2812_MENU;
  main_menu+=";";
}
//--------------------------------------------------------
#define EFFECT_N(x,clp) \
currentPalette=(x);\
colorLoop = (clp);\
fillNoiseLED();\


void loop_WS2812(){
  FS_TICK(WS2812_R); 
//  effect_windows_round(128);
  FastLED.setBrightness(BRI);
  EVERY_MS(256U-SPD) 
  if (ON_OFF)
  switch (Real_EFF) {
    case 0: LEDS.showColor(CHSV(60,128,255));       break; // Ночник
    case 1: LEDS.showColor(CHSV(hue++,255,255));   break; // Цветоворот
    case 2: effect_rainbow();                   break; // Радуга
    case 3: effect_windows_round(SCA);          break; // Груговорот
    case 4: EFFECT_N(CloudColors_p,0)           break; // Oблaкa
    case 5: EFFECT_N(LavaColors_p,0)            break; // Лaвa 
    case 6: EFFECT_N(PartyColors_p,1)           break; // Плазма 
    case 7: EFFECT_N(RainbowColors_p,1)         break; // Хаос
    case 8: EFFECT_N(RainbowStripeColors_p,1)   break; // Пaвлин
    case 9: EFFECT_N(ForestColors_p,0)          break; // Лес
    case 10: EFFECT_N(OceanColors_p,0)          break; // Океан
    case 11: EFFECT_N(WoodFireColors_p,0)       break; // Апельсин
    case 12: EFFECT_N(NormalFire_p,0)           break; // Огонь
    case 13: EFFECT_N(NormalFire2_p,0)          break; // Огонь с сиреневым

    case 14: EFFECT_N(LithiumFireColors_p,0)    break; // 
    case 15: EFFECT_N(SodiumFireColors_p,0)     break; // Лимон
    case 16: EFFECT_N(GrassFireColors_p,0)      break; // 
    case 17: EFFECT_N(SkyFireColors_p,0)        break; // Небо
    case 18: EFFECT_N(RubidiumFireColors_p,0)   break; // 
    case 19: EFFECT_N(PotassiumFireColors_p,0)  break; // 
    case 20: EFFECT_N(ZebraColors_p,0)          break; // Зебра
    case 21: LEDS.showColor(CHSV(CLR,255,255)); break; // Цвет
} else LEDS.showColor(CRGB(0,0,0));

  #ifndef GH_NO_MQTT // Отсылка значений на MQTT сервер
  if (old_Real_EFF != Real_EFF) { old_Real_EFF = Real_EFF; hub.sendGet("EFF", Real_EFF); }
  if (old_BRI != BRI) { old_BRI = BRI; hub.sendGet("BRI", BRI); }
  if (old_SPD != SPD) { old_SPD = SPD; hub.sendGet("SPD", SPD); }
  if (old_SCA != SCA) { old_SCA = SCA; hub.sendGet("SCA", SCA); }
  if (old_CLR != CLR) { old_CLR = CLR; hub.sendGet("CLR", CLR); }
  #endif

}
//--------------------------------------------------------
void parsing_WS2812(char act_chr[]){
    String act=String(act_chr)+" ";
    act.toUpperCase();

    String strCommand=getValue(act,' ',0);
    String strParam=getValue(act,' ',1);
    uint8_t intParam;
    bool Old_ON_OFF=ON_OFF;
    if (strCommand=="P_ON") { ON_OFF = true; HUB_Update=true; goto metka_end;}
    if (strCommand=="P_OFF") { ON_OFF = false; rassvet=0; HUB_Update=true; goto metka_end;}
    if ((strCommand=="ON_OFF") || (strCommand=="SWITCH") || (strCommand=="P_SW") || (strCommand=="SW")) { ON_OFF = !ON_OFF; rassvet=0; HUB_Update=true; goto metka_end;}
    intParam=str_to_int(strParam);

    if (strCommand=="BRI") {
      if (strParam == "+") (BRI<255) ? BRI++ : 255 ; else
      if (strParam == "-") (BRI>0) ? BRI-- : 0 ; else
      BRI = intParam; 
      if (BRI) ON_OFF = true;
      HUB_Update=true;
      goto metka_end;
    }
    if (strCommand=="SPD") {
      if (strParam == "+") (SPD<255) ? SPD++ : 255 ; else
      if (strParam == "-") (SPD>0) ? SPD-- : 0 ; else
      SPD = intParam; 
      HUB_Update=true;
      goto metka_end;
    }
    if (strCommand=="CLR") { // Цвет по кругу.
      if (strParam == "+") CLR++; else
      if (strParam == "-") CLR--; else
      CLR = intParam; 
      HUB_Update=true;
      goto metka_end;
    }
    if (strCommand=="SCA") { // Цвет по кругу.
      if (strParam == "+") SCA++; else
      if (strParam == "-") SCA--; else
      SCA = intParam; 
      HUB_Update=true;
      DEBUGLN("SCA goto metka_end;");
      goto metka_end;
    }//-------------------------------    
    if ((strCommand=="Рассвет") || (strCommand=="РАССВЕТ")){
      length_rassvet=10;
      if (strParam == "OFF") rassvet=0; else
      if ((strParam=="ON_OFF") || (strParam=="SWITCH")) { 
          if (rassvet==0) rassvet=1; else rassvet=0; 
      } else {
        if (strParam>"") length_rassvet=intParam; 
        rassvet=1;
      }  
      ON_OFF = rassvet;
      goto metka_end;
    }
//-------------------------------    
    FOR_i(0,MAX_EFF) act.replace(getValue(NAME_EFF,';',i)+" ", "EFF "+String(i)+" ");
    DEBUG("parsing_WS2812 : ");
    DEBUGLN(act);
    strCommand=getValue(act,' ',0);
    strParam=getValue(act,' ',1);
    intParam=str_to_int(strParam);
    if ((strCommand=="SET") || (strCommand=="EFF")) {   // команда SET eff bri spd sca clr
      if (strParam == "+") Real_EFF = (Real_EFF+1) % MAX_EFF; else
      if (strParam == "-") Real_EFF = (MAX_EFF+Real_EFF-1) % MAX_EFF; 
      strParam=getValue(act,' ',2);
      if (strParam=="OFF") { ON_OFF = false; rassvet=0; HUB_Update=true; goto metka_end;}
      if ((strParam=="ON_OFF") || (strParam=="SWITCH") || (strParam=="P_SW") || (strParam=="SW")) { ON_OFF = !ON_OFF; rassvet=0; HUB_Update=true; goto metka_end;}
      if (intParam < MAX_EFF) {Real_EFF = intParam; ON_OFF = true; }
      intParam=str_to_int(strParam);
      if ((strParam > "") && (strParam != "*") && (strParam != "ON")){ 
          BRI=intParam;
          if (BRI) ON_OFF = true;
          }
      strParam=getValue(act,' ',3);   if ((strParam > "") && (strParam != "*")) SPD=str_to_int(strParam);
      strParam=getValue(act,' ',4);   if ((strParam > "") && (strParam != "*")) SCA=str_to_int(strParam);
      strParam=getValue(act,' ',5);   if ((strParam > "") && (strParam != "*")) CLR=str_to_int(strParam);
      HUB_Update=true;
    } 
metka_end:

    if (BRI==0) ON_OFF = false; 
//    to_Matrix();
    EVERY_MS(1000) 
    if (HUB_Update && hub.focused()) {
      hub.sendUpdate("EFF", String(Real_EFF));
      hub.sendUpdate("sw_EFF", String(ON_OFF));
      hub.sendUpdate("BRI", String(BRI));
      hub.sendUpdate("SPD", String(SPD));
      hub.sendUpdate("SCA", String(SCA));
      hub.sendUpdate("CLR", String(CLR));
      HUB_Update=false;
    }
    if (Old_ON_OFF!=ON_OFF) {
       char send_udp[25];
       sprintf_P(send_udp, (const char *)F("WS2812 IS %s"), (ON_OFF) ? "ON":"OFF");
       module_parsig(255,send_udp);
    }
}
//--------------------------------------------------------
void HUB_module_pult_WS2812(gh::Builder& b) {
  b.beginRow();  
    b.Select_("EFF",&Real_EFF).text(F(NAME_EFF)).size(3).label(F("Эффект"));
    b.Switch_("sw_EFF",&ON_OFF).label(F("Включить")).size(1); 
  b.endRow(); 
}
//--------------------------------------------------------
void HUB_module_WS2812(gh::Builder& b) {
  String st_tab="0";
  static uint8_t tab = 0;
  HUB_module_pult_WS2812(b);
  b.Slider_("BRI",&BRI).label(F("Яркость")).range(0, 255, 1);
  b.Slider_("SPD",&SPD).label(F("Скорость")).range(0, 255, 1);
  b.Slider_("SCA",&SCA).label(F("Масштаб")).range(0, 255, 1);
  b.Slider_("CLR",&CLR).label(F("Цвет")).range(0, 255, 1);
/*  
   if (eeprom_flag) {
      FS_UPDATE(WS2812_R);
      eeprom_flag=false;
   }
*/   
}
//--------------------------------------------------------
void load_WS2812(){

}

//--------------------------------------------------------
void get_WS2812() {
  char send_udp[25];
  Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
  sprintf_P(send_udp, (const char *)F("WS2812 IS %s"), (ON_OFF) ? "ON":"OFF");
  Udp.print(send_udp);
  Udp.endPacket();
}  
//--------------------------------------------------------
// Утилиты для эффектов
//--------------------------------------------------------
void SaluteFadeAll(uint8_t val)
{ 
  FOR_i(0,NUM_LEDS) leds[i]-=CHSV(0,0,val);
}

//--------------------------------------------------------
// Эффекты
//--------------------------------------------------------
// Бег по кругу с затуханием
void effect_windows_round(uint8_t HUE_COLOR) {
   static uint8_t x = 0;
   leds[x++]=CHSV(HUE_COLOR,255,255);
   x=x % NUM_LEDS;
   SaluteFadeAll(30);
   FastLED.setBrightness(BRI);
   FastLED.show();
}
//--------------------------------------------------------
// Радуга по кругу
void effect_rainbow() {
   static uint8_t x = 0;
   FOR_i(0, NUM_LEDS) {
      leds[i] = CHSV(x++ + i*255/NUM_LEDS, 255,255); 
   }
   FastLED.setBrightness(BRI);
   FastLED.show();
}
//--------------------------
void fillNoiseLED()
{
  static uint16_t x;
  static uint16_t y;
  static uint16_t z;
  uint8_t dataSmoothing = 0;
  if (SPD < 50) dataSmoothing = 200 - (SPD * 4);

  for (uint8_t i = 0; i < NUM_LEDS; i++)
  {
    uint8_t data = inoise8(x + SCA * i, y , z);
    data = qsub8(data, 16);
    data = qadd8(data, scale8(data, 39));
      
    if (dataSmoothing)
    {
      uint8_t olddata = noise[i];
      uint8_t newdata = scale8( olddata, dataSmoothing) + scale8( data, 256 - dataSmoothing);
      data = newdata;
    }
    noise[i] = data;
  }
  x += 10;
  y += 20;
  z -= 5;

  for (uint8_t i = 0; i < NUM_LEDS; i++)
  {
      uint8_t bri =   noise[i];
      uint8_t index = noise[NUM_LEDS-i];
      if ( colorLoop) index += hue;
      if ( bri > 127 ) bri = 255;
      else bri = dim8_raw( bri * 2);
      CRGB color = ColorFromPalette( currentPalette, index, bri);      
      leds[i] = color;
  }
  hue += 1;
  FastLED.setBrightness(BRI);
  FastLED.show();
}

//--------------------------------


#endif
#endif
