#if defined (MAX_TIMER)

//--------------------------------------------------------
struct struct_TIMER{
  bool on_off;
  char timer_name[CMD_LEN];
  char cmd_start[CMD_LEN];
  char cmd_active[CMD_LEN];
  char cmd[CMD_LEN];
  uint32_t time_from=0;
  uint32_t time_to=0;
  GH::Flags week=255;
  GH::Flags lamp=0;
  GH::Flags modul=0;
  uint32_t timer=15; //15 минут по умолчанию
  uint32_t tik_tik=0;
  bool ok=true;
  GH::Color col=gh::Colors::Aqua;
  bool change_hub=false;
  char rezerv_byte[4];
};
struct_TIMER TIMER[MAX_TIMER];
FS_(TIMER);
//--------------------------------------------------------
void setup_TIMER(){
  strcpy(TIMER[0].timer_name, "STARTUP");
  FS_LOAD(TIMER); 
  FOR(tab,0,MAX_TIMER) TIMER[tab].on_off=false;
  main_menu+=TIMER_MENU;
  main_menu+=";";
}
//--------------------------------------------------------
void hub_update_loop_TIMER(){
 //if (!HUB_Update) return;
  FOR_i(0,MAX_TIMER)
    if (TIMER[i].on_off) {
         String h_s;
         String h_m;
         h_s=String(((TIMER[i].tik_tik-millis())/1000)%60);
         h_m=String((TIMER[i].tik_tik-millis())/60000);
         if (((TIMER[i].tik_tik-millis())/1000)%60<10) h_s="0"+h_s;
         if (hub.focused()) {
            hub.sendUpdate("tik_TIM"+String(i), h_m+":"+h_s);
            hub.sendUpdate("sw_TIM"+String(i), "1");
         }   
         #ifndef GH_NO_MQTT   // Отсылка значений на MQTT сервер
         if (strlen(TIMER[i].timer_name)>0) {
//         hub.sendGet("tik_TIM"+String(i), (TIMER[i].tik_tik-millis())/1000);
//         hub.sendGet("tik_TIM"+String(i), h_m+":"+h_s);
           hub.sendGet("sw_TIM"+String(i),&TIMER[i].on_off);
         }
         #endif
         TIMER[i].change_hub=true;
    } else {
           if (TIMER[i].change_hub) {
             if (hub.focused()) {
                hub.sendUpdate("tik_TIM"+String(i), "0");
                hub.sendUpdate("sw_TIM"+String(i), "0");
             }   
             #ifndef GH_NO_MQTT   // Отсылка значений на MQTT сервер
//             hub.sendGet("tik_TIM"+String(i), 0);
//             hub.sendGet("sw_TIM"+String(i),&TIMER[i].on_off);
             #endif
             TIMER[i].change_hub=false;
           }
    }  
}
//--------------------------------------------------------
void send_on_time(uint8_t i, char act[]) {
 if (strlen(act))
   if (TIMER[i].week.get(dayofweek)) {
     bool on_time=false;
     if (TIMER[i].time_from<TIMER[i].time_to) 
         on_time=(hour*60+minute>=round(TIMER[i].time_from/60)) && (hour*60+minute<round(TIMER[i].time_to/60));
     else    
         on_time=(hour*60+minute>=round(TIMER[i].time_from/60)) || (hour*60+minute<round(TIMER[i].time_to/60));
     if (on_time) {
           module_parsig(TIMER[i].modul,act);
           IP_parsig(TIMER[i].lamp,act);
     }
   }   
}
//--------------------------------------------------------
void loop_TIMER(){
  EVERY_MS(1000) {
  FS_TICK(TIMER); 
  FOR_i(0,MAX_TIMER) {
    if (TIMER[i].on_off) {
      if (TIMER[i].tik_tik<millis())
      {
        TIMER[i].on_off=false;
        TIMER[i].tik_tik=0;
        send_on_time(i,TIMER[i].cmd);
      } else {
        if (TIMER[i].ok) {  //запуск таймера
           send_on_time(i,TIMER[i].cmd_start);
           TIMER[i].ok=false;
        }
        send_on_time(i,TIMER[i].cmd_active);
      }
    } else TIMER[i].ok=true;
  } // for
  hub_update_loop_TIMER();
  } // EVERY_MS(1000)
}

//--------------------------------------------------------
template<typename T>
void parsing_TIMER(T act_chr){
    String act=String(act_chr)+" ";
    act.toUpperCase();
    FOR_i(0,MAX_TIMER) 
    {
      String act_i=act;
      if (strlen(TIMER[i].timer_name)) 
        act_i.replace(getValue(String(TIMER[i].timer_name)+" ",',',0)+" ", "TIM "+String(i)+" ");
      String strCommand=getValue(act_i,' ',0);
      if (strCommand=="P_OFF") { if (TIMER[i].on_off) TIMER_Start(i,false);} else
      if ((strCommand=="TIMER") || (strCommand=="TIM")){
        String argstr = getValue(act_i,' ',1);
        uint8_t argint=argstr.toInt();
        if (argint == i) {
           DEBUGLN(act_i);
           argstr = getValue(act_i,' ',2);
           uint8_t argint1=str_to_int(argstr);
           if (argstr=="ON") TIMER_Start(argint,true); else
           if (argstr=="OFF") TIMER_Start(argint,false); else
           if ((argstr=="SWITCH") || (argstr=="SW")) TIMER_Start(argint,!TIMER[i].on_off); 
           else {
            if (argstr>"") TIMER[argint].timer=argint1;
            TIMER_Start(argint,true);
           }
        }
      }
    }
}
//--------------------------------------------------------
void TIMER_Start(uint8_t tim,bool ON_OFF) {
  if (tim<MAX_TIMER) {
    DEBUGLN("TIMER_Start " + String(tim)+" "+String(ON_OFF)); 
    TIMER[tim].on_off=ON_OFF;
    TIMER[tim].tik_tik=millis()+TIMER[tim].timer*60000+1000;
    if (ON_OFF) {
       send_on_time(tim,TIMER[tim].cmd_start);
       TIMER[tim].ok=false;
    }
    else if (strcmp(TIMER[tim].timer_name,TIMER[tim].cmd)!=0) {
      send_on_time(tim,TIMER[tim].cmd);
    }
  }
}
//--------------------------------------------------------
void HUB_module_pult_TIMER(gh::Builder& b) {
  FOR_i(0,MAX_TIMER) 
   if (TIMER[i].on_off || strlen(TIMER[i].timer_name)){
    b.beginRow();  
//    hub.WidgetSize(44);
    b.Display(TIMER[i].timer_name).label("Имя "+String(i)+" таймера").fontSize(16).rows(1).size(2).color(TIMER[i].col);
//    hub.WidgetSize(30);
    b.Display_("tik_TIM"+String(i),F("0")).label("оставшееся время до "+String(TIMER[i].cmd)).color(TIMER[i].col).fontSize(16).rows(1).size(1);
//    hub.WidgetSize(26);
    if (b.Switch_("sw_TIM"+String(i),&TIMER[i].on_off).label(F("Active")).color(TIMER[i].col).click() ) TIMER_Start(i,TIMER[i].on_off);
    b.endRow();  
  }
}
//--------------------------------------------------------
void HUB_module_TIMER(gh::Builder& b) {
  static uint8_t plus_minus[MAX_TIMER];
  String h_m;
  String h_s;
  
  FOR(tab,0,MAX_TIMER) {
     b.beginRow();  
     if (b.Switch_("sw_TIM"+String(tab),&TIMER[tab].on_off).label(String(tab)+". Active").color(TIMER[tab].col).size(1).click()) TIMER_Start(tab,TIMER[tab].on_off);
     eeprom_flag |= b.Input(TIMER[tab].timer_name).maxLen(HUB_LEN).color(TIMER[tab].col).size(3).label(F("Имя таймера / Условие")).click();
     if (b.Tabs(&plus_minus[tab]).text(F("- ; +")).size(1).color(TIMER[tab].col).click()) b.refresh();
     b.endRow();  
     if (plus_minus[tab]) {
         b.beginRow();  
         eeprom_flag |= b.Input(&TIMER[tab].timer).label("Таймер "+String(tab)).click();
         b.Display_("tik_TIM"+String(tab),F("0")).rows(1).label(F("оставшееся время"));
         b.endRow();  
         b.beginRow();  
         eeprom_flag |= b.Time(&TIMER[tab].time_from).label(F("От")).size(2).click();
         eeprom_flag |= b.Time(&TIMER[tab].time_to).label(F("До")).size(2).click();
         eeprom_flag |= b.Color(&TIMER[tab].col).click();
         b.endRow();  
         eeprom_flag |= b.Flags(&TIMER[tab].week).text(str_dayofweek).label(F("Дни недели")).click();
         eeprom_flag |= b.Input(TIMER[tab].cmd_start).label(F("Команда при старте")).maxLen(HUB_LEN).click();
         eeprom_flag |= b.Input(TIMER[tab].cmd_active).label(F("Команда при активности")).maxLen(HUB_LEN).click();
         eeprom_flag |= b.Input(TIMER[tab].cmd).label(F("Команда на финише")).maxLen(HUB_LEN).click();
         eeprom_flag |= b.Flags(&TIMER[tab].lamp).text(str_GHflags_IP).label(F("Устройства IP")).click();
         eeprom_flag |= b.Flags(&TIMER[tab].modul).text(str_modul).label(F(hlp_modul)).click();
     }
  }
  if (eeprom_flag) {
      FS_UPDATE(TIMER);
      eeprom_flag=false;
//      DEBUGLN("Timer Update");
  }
}
//--------------------------------------------------------
void load_TIMER(){

}
#endif
