#if defined (TX433_PIN)
// Управление TX433_PIN
/*
 * Обрабатываются команды
 433 DEC_CODE
 433x HEX_CODE
 433X HEX_CODE
 433h HEX_CODE
 433H HEX_CODE
 DEC_CODE
 */

#include <RCSwitch.h>
RCSwitch TX_433_Switch = RCSwitch();

//--------------------------------------------------------
void setup_TX433() {
  TX_433_Switch.enableTransmit(TX433_PIN);
  TX_433_Switch.setProtocol(1);
}
//--------------------------------------------------------
void loop_TX433() {
}
//--------------------------------------------------------
// Парсит команды из Ararm,Сети,ИК
template<typename T>
void parsing_TX433(T act_chr) {
    String act=String(act_chr);
    act.toUpperCase();
//    DEBUGLN(act);
    String strCommand=getValue(act,' ',0);
    String str433=getValue(act,' ',1);
//    DEBUGLN(strCommand);
    uint32_t cmd433=0;
    
    if (strCommand=="433X") cmd433=strtoul(str433.c_str(), 0, 16); else
    if (strCommand=="IRX") cmd433=strtoul(str433.c_str(), 0, 16); else
    if (strCommand=="433H") cmd433=strtoul(str433.c_str(), 0, 16); else
    if (strCommand=="IR") cmd433=str_to_int(str433); else
    if (strCommand=="433") cmd433=str_to_int(str433); else
    cmd433=str_to_int(strCommand);
    if (cmd433!=0) TX_433_Switch.send(cmd433, 24);
}
//--------------------------------------------------------


#endif
