#if defined (SR501_PIN)

//--------------------------------------------------------
struct struct_sr501{
  bool on_off;
  bool alarm;
  bool repeat;
  char cmd_on[CMD_LEN];       // Посылаемая команда при сработке
  char cmd_on_rep[CMD_LEN];   // Посылаемая команда во время сработки
  char cmd_off[CMD_LEN];      // Посылаемая команда после сработки
  char cmd_off_rep[CMD_LEN];  // Посылаемая команда во время пассива
  uint32_t time_from=0;
  uint32_t time_to=0;
  GH::Flags week=255;
  GH::Flags lamp=0;
  GH::Flags modul=0;
  GH::Flags timers=0;
  bool ok_on=true;
  bool ok_off=true;
};
struct_sr501 sr501[MAX_SR501];
FS_(sr501);

bool sr501_s;
bool old_sr501_s;
//--------------------------------------------------------
void setup_SR501(){
  pinMode(SR501_PIN,INPUT);     
  FS_LOAD(sr501); 
  main_menu+=SR501_MENU;
  main_menu+=";";
}
//--------------------------------------------------------
void get_SR501() {
    char send_udp[25];
    Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
    sprintf_P(send_udp, (const char *)F("SR501 IS %s"), (sr501_s) ? "ON":"OFF");
    Udp.print(send_udp);
    Udp.endPacket();
}  
//--------------------------------------------------------
void SR501_send(uint8_t i, char cmd[]) {
  module_parsig(sr501[i].modul,cmd);
  IP_parsig(sr501[i].lamp,cmd);
}
//--------------------------------------------------------
void loop_SR501(){
  EVERY_MS(1000) {
  sr501_s=digitalRead(SR501_PIN);
//  if (hub.focused()) hub.update("led").value(String(sr501_s));  // обновляем светодиод датчика движения sr501
  FS_TICK(sr501); 
  FOR_i(0,MAX_SR501)
   if (sr501[i].on_off) 
     if (sr501[i].week.get(dayofweek)) {
          bool on_time=false;
          if (sr501[i].time_from<sr501[i].time_to) 
              on_time=(hour*60+minute>=round(sr501[i].time_from/60)) && (hour*60+minute<=round(sr501[i].time_to/60));
          else    
              on_time=(hour*60+minute>=round(sr501[i].time_from/60)) || (hour*60+minute<=round(sr501[i].time_to/60));

          if (on_time) {
             if (sr501_s) {
               if (sr501[i].ok_on) if (strlen(sr501[i].cmd_on)) { SR501_send(i,sr501[i].cmd_on); sr501[i].ok_on=false;}
               if (strlen(sr501[i].cmd_on_rep)) SR501_send(i,sr501[i].cmd_on_rep);
               sr501[i].ok_off=true;
             } else {
               if (sr501[i].ok_off) if (strlen(sr501[i].cmd_off)) { SR501_send(i,sr501[i].cmd_off); sr501[i].ok_off=false;}
               if (strlen(sr501[i].cmd_off_rep)) SR501_send(i,sr501[i].cmd_off_rep);
               sr501[i].ok_on=true;
             }
          } else {
             sr501[i].ok_on=true;
             sr501[i].ok_off=true;
          }
     }
  #ifndef GH_NO_MQTT // Отсылка значений на MQTT сервер
//  if (sr501_s!=old_sr501_s) hub.sendGet("led", sr501_s);
  if (sr501_s) hub.sendGet("led", sr501_s);
  #endif
  } //1000 мс
 old_sr501_s=sr501_s;
}
//--------------------------------------------------------
template<typename T>
void parsing_SR501(T act_chr){
    String act=String(act_chr)+" ";
    act.toUpperCase();
    DEBUGLN(act);
    String  strCmd=getValue(act,' ',0);
    if (strCmd!="SR501") return;
    String  strNum=getValue(act,' ',1);
    String  strArg=getValue(act,' ',2);
    uint8_t intNum=strNum.toInt();
    if (strNum=="*") intNum=MAX_SR501;
    if (intNum<MAX_SR501)
    {
       if (strArg=="ON")  sr501[intNum].on_off=true; else
       if (strArg=="OFF") sr501[intNum].on_off=false; else
       if ((strArg=="SWITCH") || (strArg=="SW")) sr501[intNum].on_off = !sr501[intNum].on_off;
    } else
    if (intNum==MAX_SR501)
    FOR_i(0,MAX_SR501) {
       if (strArg=="ON")  sr501[i].on_off=true; else
       if (strArg=="OFF") sr501[i].on_off=false; else 
       if ((strArg=="SWITCH") || (strArg=="SW")) sr501[i].on_off = !sr501[i].on_off;
    }
  
}
//--------------------------------------------------------
void HUB_module_SR501(gh::Builder& b) {
  static uint8_t plus_minus[MAX_SR501];
  static uint8_t tab = 0;
  b.LED_(F("led"), &sr501_s).label(F("Датчик движения"));
  
  FOR(tab,0,MAX_SR501) {
     b.beginRow();  
      eeprom_flag |= b.Time(&sr501[tab].time_from).label(F("От")).size(2).color(sr501[tab].on_off ?  gh::Colors::Green : gh::Colors::Yellow).click();
      eeprom_flag |= b.Time(&sr501[tab].time_to).label(F("До")).size(2).color(sr501[tab].on_off ?  gh::Colors::Green : gh::Colors::Yellow).click();
      if (b.Tabs(&plus_minus[tab]).text(F("- ; +")).size(1).click()) b.refresh();
     b.endRow();  
    if (plus_minus[tab]) {
      eeprom_flag |= b.Flags(&sr501[tab].week).text(str_dayofweek).label(F("Дни недели")).click();
      {
        gh::Row r(b);
        eeprom_flag |= b.Switch_("sr501_sw"+String(tab),&sr501[tab].on_off).label(F("Active")).size(1).click();
         {   
            gh::Col c(b,4);
            eeprom_flag |= b.Input(sr501[tab].cmd_on     ).maxLen(HUB_LEN).label(F("Команда при сработке")).color(gh::Colors::Green).click();
            eeprom_flag |= b.Input(sr501[tab].cmd_on_rep ).maxLen(HUB_LEN).label(F("Команда во время сработки")).color(gh::Colors::Green).click();
            eeprom_flag |= b.Input(sr501[tab].cmd_off    ).maxLen(HUB_LEN).label(F("Команда после сработки")).color(gh::Colors::Red).click();
            eeprom_flag |= b.Input(sr501[tab].cmd_off_rep).maxLen(HUB_LEN).label(F("Команда во время пассива")).color(gh::Colors::Red).click();
         }//Row
      }
      eeprom_flag |= b.Flags(&sr501[tab].lamp).text(str_GHflags_IP).label(F("Устройства IP")).click();
      eeprom_flag |= b.Flags(&sr501[tab].modul).text(str_modul).label(F(hlp_modul)).click();
   }
  } // FOR
   if (eeprom_flag) {
      FS_UPDATE(sr501);
      eeprom_flag=false;
   }
}

//--------------------------------------------------------
void load_SR501(){
   String CONFIG="";
   FOR_i(0,MAX_SR501) {
    CONFIG+="SR501;"+String(i);
    if (sr501[i].on_off) CONFIG+=";1;";
                      else CONFIG+=";0;";
    CONFIG+=String(sr501[i].alarm)+";";
    CONFIG+=String(sr501[i].time_from/3600)+":"+String((sr501[i].time_from/60)%60)+";";
    CONFIG+=String(sr501[i].time_to/3600)+":"+String((sr501[i].time_to/60)%60)+";";
    CONFIG+=sr501[i].week.toString()+";"+sr501[i].lamp.toString()+";"+sr501[i].modul.toString()+";";
    CONFIG+=String(sr501[i].cmd_on)+";";
    CONFIG+=String(sr501[i].cmd_on_rep)+";";
    CONFIG+=String(sr501[i].cmd_off)+";";
    CONFIG+=String(sr501[i].cmd_off_rep)+";"+char(10);
   }
   Udp.print(CONFIG.c_str());
   Udp.print(char(10));
}

#endif
