//--------------------------------------------------------
// Задайте имя для устрйства, что бы вам было легче его найти
// например #define HUB_NAME "Кухня"
#define HUB_NAME            "hous_home" // Имя для GyverHub и и ответа на DISCOVER
#define HUB_ICO             "💧"
//#define HUB_ICO             "☔"
//--------------------------------------------------------
#define ESP_UDP_PORT        (8888U)  // номер порта, который будет слушать UDP сервер во время работы лампы как в режиме WiFi точки доступа, так и в режиме WiFi клиента (лучше не менять)
#define MAX_EFF_GYVER       91       // Максимальное количество эффектов для совместимости с лампами
#define MAX_UDP_BUFFER_SIZE (512U)   // максимальный размер буффера UDP сервера
//--------------------------------------------------------
// Количество IP адресов соседей, которым можно посылать команды 
#define MAX_IP              7       // Максимальное количество - 16 из за особенностей GHflags
//--------------------------------------------------------
//#define str_modul           "РЕЛЕ;ШИМ;LED;TIM;MP3;433;IR"
#define str_modul           "⚡;☵;🌈;⏱;🔊;➿;⭕"
#define hlp_modul           "Модули - Реле ШИМ WS2812 Timer MP3 TX_433 TX_IR"
#define str_dayofweek       "Вс;П;В;С;Ч;Пт;Сб" 

//--------------------------------------------------------
// Подключение дополнительных модулей. Ненужные закоментировать
//--------------------------------------------------------
// модуль module_GyverLamp.ino
// Добавляет запрос и сихронизацию
// #define GyverLamp
#if defined (GyverLamp)
// Флаг синхронизации ламп с 0 на остальные
bool copy_to_all=true;
FS_(copy_to_all);
#endif
uint8_t effect=0;
//--------------------------------------------------------
// модуль module_Alarm.ino
#define MAX_ALARMS          5       // Максимальное количество будильников
#define ALARM_MENU          "⏰"

//--------------------------------------------------------
// модуль module_G220.ino
// #define RELE_PIN            (1U)      // Количество реле
// Список пинов, к которым подключается реле в module_G220.ino  
// Для ESP-01 Пин 0 - GPIO0, 2 - GPIO2  {0} , {0,2}
// 1 - {0}; 2 - {0,2}
#define RELE_PINS {0,2}

//--------------------------------------------------------
// модуль module_IR.ino
//#define IR_PIN              (5U)     // для Wemos Пин D1 для ESP-01 - 2 - GPIO2
// Максимальное количество IR команд (кнопок на пульте). Если пультов много, добавляйте
#define MAX_IR              (20U)    
#define IR_MENU           "⭕"
//--------------------------------------------------------
// модуль module_TX_IR.ino
// #define TX_IR_PIN              (14)     // GPIO14
//--------------------------------------------------------
// модуль module_RX433.ino
// #define RX433_PIN              (D1)     // для Wemos Пин D1 для ESP-01 - 2 - GPIO2
// Максимальное количество команд (кнопок на 433 пультах). Если пультов много, добавляйте
#define MAX_RX433              (15U)    
//#define RX433_MENU           "♶"  // Выбор иконки
//#define RX433_MENU           "➰"
#define RX433_MENU           "➿"
#define RX433_delay          1000       // ограничение 1 секунда между одинаковыми командами при отключеном повторе

//--------------------------------------------------------
// модуль module_TX433.ino
// #define TX433_PIN              (D1)     // для Wemos Пин D1 для ESP-01 - 2 - GPIO2
//--------------------------------------------------------
// модуль module_SR501.ino
//#define SR501_PIN         (13U)       // Датчик движения
#define MAX_SR501         (5U)      // Количество событий
//#define SR501_MENU         "❂"
#define SR501_MENU         "⚽"
//--------------------------------------------------------
// модуль module_Translater.ino в разработке
//#define MAX_SENDS           3        // Максимальное количество адресов пересылки

//--------------------------------------------------------
// модуль module_Timer.ino 
#define MAX_TIMER           15       // Максимальное количество таймеров
//#define TIMER_MENU          "⏳"
#define TIMER_MENU          "⏱"

//--------------------------------------------------------
// модуль управления ШИМ сигналом
#define  PWM_PIN 2
// Список пинов, к которым подключается реле в module_PWM.ino
// Для ESP-01 Пин 0 - GPIO0, 2 - GPIO2  {0} , {0,2}
// 1 - {0}; 2 - {0,2}
#define PWM_PINS {0,2}

//--------------------------------------------------------
// модуль WS2812
#define WS2812_PIN           (0)       // D3
#define WS2812_MENU          "🌈"
#define WS2812_PAINT         "🎨"
#define COLOR_ORDER           (GRB)     // порядок цветов на ленте. Если цвет отображается некорректно - меняйте. Начать можно с RGB
// 1 - лента, 2 - матрица
#define WS2812_D               2         // module_WS2812_1D.ino - 1, module_WS2812_2D.ino - 2
//--------------------------------------------------------
// модуль module_DHT22.ino
//#define DHT_PIN              (4U)
#define DHT_MENU             "🌡💧"
//--------------------------------------------------------
//module_GButton.ino
#define BTN_PIN              (4U)       //D2    
#define BTN_MENU             "🔘"
#define MAX_G_Button           10       // Максимальное количество действий
//--------------------------------------------------------
//module_DFPlayer.ino
//#define DFPlayer
#define MP3_TX_PIN            (12U)    // artuinio TX mp3 player RX (D6)
#define MP3_RX_PIN            (14U)    // artuinio RX mp3 player TX (D5)
#define DFP_MENU             "🔊"
//--------------------------------------------------------


//--------------------------------------------------------
// Длинна переменной для команды
#define HUB_LEN 25
#define CMD_LEN HUB_LEN*2+1
//для ответа на запрос DISCOVER
#define DISCOVER "IP %u.%u.%u.%u:%u:" HUB_NAME

String main_menu="PULT;IP;";
char packetBuffer[MAX_UDP_BUFFER_SIZE]; // buffer to hold incoming packet
char inputBuffer[MAX_UDP_BUFFER_SIZE];

//GyverHub hub("MyDevices", HUB_NAME, "⚡");
GyverHub hub("MyDevices",HUB_NAME,HUB_ICO);
bool HUB_Update=false; 
uint16_t localPort = ESP_UDP_PORT;

bool ON_OFF = false; // Общий тригер включения/выключения
WiFiUDP Udp;

WiFiUDP ntpUDP;
int hour = 1;
int minute = 0;
int dayofweek=0;

uint64_t ntp_update_time=0;
const long utcOffsetInSeconds = 10800;

NTPClient timeClient(ntpUDP, "pool.ntp.org",utcOffsetInSeconds);
bool eeprom_flag=false;

//--------------------------
String str_GHflags_IP="0";

struct struct_ip_addr{
  bool on_off;
  char ipchr[CMD_LEN];
  GH::Flags copy_attr;
  GH::Color col;
//  uint32_t col_hex=GH_AQUA;
};

struct_ip_addr ip_addr[MAX_IP];
FS_(ip_addr);
//--------------------------
struct struct_lamp_status{
  bool online;
  bool on_off;
  uint32_t last_input_udp=0;
  String name;
  uint8_t eff;
  uint8_t BRI;
  uint8_t SPD;
  uint8_t SCA;
};

struct_lamp_status lamp_status[MAX_IP];

const String REGEX_IP="^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$";
uint32_t ntp_time;
