//#define IP_STATIC                 // Если нужен статический IP, раскоментируйте
#if defined (IP_STATIC)
IPAddress ip(192,168,100,200);    //Node static IP
IPAddress gateway(192,168,100,1);
IPAddress subnet(255,255,255,0);
#endif

FS_(portalCfg); // Для сохранения настроек WiFi

bool success;

bool setupSTA() {
  DEBUG("Connecting to AP... ");
  WiFi.softAPdisconnect();
  WiFi.disconnect();
#if defined (IP_STATIC)
  WiFi.config(ip, gateway, subnet, gateway);
#endif
  WiFi.hostname(HUB_NAME);
  WiFi.mode(WIFI_STA);
  WiFi.begin(portalCfg.SSID, portalCfg.pass);
  uint32_t tmr = millis();
  bool state = false;
  while (millis() - tmr < 30000) {
    #if defined (WS2812_RING)
    EVERY_MS(100) effect_windows_round(176);
    #endif
    if (WiFi.status() == WL_CONNECTED) {
      DEBUGLN("ok");
      DEBUGLN(WiFi.localIP());
      WiFi.setAutoReconnect(true);
      WiFi.persistent(true);
      #if defined (WS2812_PIN)
      LEDS.showColor(CRGB(0, 32, 0)); // зеленый
      delay(500);
      #endif
      return true;
    }
    yield();
  }
  DEBUGLN("fail");
  success = false;
  return false;
//  portalRoutine();
}

//-----------------------------------------------
// Считывает файл wifi.dat
// В случае какой либо неудачи запускает портал с сетью "ESP Config"
void Connect_WiFi_Portal() {
  uint32_t tim_portal=millis();
  success=true;
  if (FS_LOAD(portalCfg)) success=false;
//  else DEBUGLN(portalCfg.SSID);
  do {
  if (!success)
   {
    DEBUGLN("Start Portal");
    LEDS.showColor(CRGB(255, 0, 0)); // красный
    delay(500);
    portalStart();
    while (!portalTick() and (millis()-tim_portal<300000));
    if (portalStatus() == SP_SUBMIT) FS_SAVE(portalCfg);
   } 
  } while(!setupSTA()); 
}

//-----------------------------------------------
