#if defined (PWM_PIN)

// Управление ШИМ на пинах
/*
 * Обрабатываются команды
 * P_ON       - включит ШИМ на максимум 100% (esp8266 - 1023, esp32-4095)
 * P_OFF      - передает на ШИМ 0
 * PWM 0 xxx  - передает на ШИМ xxx
 * PWM 0 +    - увеличивает ШИМ на 1
 * PWM 0 -    - уменьшает ШИМ на 1
 * Если номер PWM больше или равен количеству действует на все
 */


#if defined(ESP32)
 #define MAX_PWM_BRI 4095 // 0..4095
 #define LEDC_TIMER_RESOLUTION   12            // От 0 до 4095
 #define LEDC_BASE_FREQ          512          // Гц
#else 
 #define MAX_PWM_BRI 1023 // 0..1023
#endif
 
// Для ESP-01 Пин 0 - GPIO0, 2 - GPIO2  {0} , {0,2}
uint8_t  pin_pwm[PWM_PIN+1]=PWM_PINS;
uint16_t signal_pwm[PWM_PIN+1]={0};
uint16_t real_pwm[PWM_PIN+1]={0};
uint16_t old_pwm[PWM_PIN+1]={false};
bool H_update=false; 

//--------------------------------------------------------
void PWM(uint8_t pin, uint16_t pwm) {
 FOR_i(0,PWM_PIN) {
   if ((i==pin) || (pin>=PWM_PIN)) {
     signal_pwm[i] = pwm;
     }
   }
 H_update=true; 
}
//--------------------------------------------------------
char P_MAX[]="PWM MAX";
char P_MIN[]="PWM MIN";
void PWM_inc(uint8_t pin, int8_t pwm) {
// DEBUGLN("PWM_inc");
 FOR_i(0,PWM_PIN) {
   if ((i==pin) || (pin>=PWM_PIN)) {
     if (pwm>0 && signal_pwm[i]<100) signal_pwm[i]++; else module_parsig(8,P_MAX);
     if (pwm<0 && signal_pwm[i]>0) signal_pwm[i]--; else module_parsig(8,P_MIN);
     }
   }
 H_update=true; 
}
//--------------------------------------------------------
void setup_PWM() {
  FOR_i(0,PWM_PIN) {
#if defined(ESP32)
  ledcSetup(i, LEDC_BASE_FREQ, LEDC_TIMER_RESOLUTION);
  ledcAttachPin(pin_pwm[i], i);
#else 
 pinMode(pin_pwm[i],OUTPUT);
#endif
 }
}
//--------------------------------------------------------
void loop_PWM() {
  char arg1[6]; 
  EVERY_MS(50) {
    FOR_i(0,PWM_PIN){
       if (real_pwm[i]>signal_pwm[i]) real_pwm[i]--;
       if (real_pwm[i]<signal_pwm[i]) real_pwm[i]++;
#if defined(ESP32)
       uint16_t b100=map(real_pwm[i],0,100,0,MAX_PWM_BRI);
       if (b100>MAX_PWM_BRI) b100=MAX_PWM_BRI;
       ledcWrite(i, b100);
#else 
       analogWrite(pin_pwm[i],bri_100_to_real(real_pwm[i],MAX_PWM_BRI));
#endif
       if (old_pwm[i]!=signal_pwm[i]) { 
           sprintf_P(arg1, (const char *)F("PWM%d"), i);
           #ifndef GH_NO_MQTT   // Отсылка значений на MQTT сервер
           hub.sendGet(arg1, signal_pwm[i]);
           #endif
           if (hub.focused()) hub.update(arg1).value(signal_pwm[i]);
           old_pwm[i]=signal_pwm[i];
       }
    }
  }
}
//--------------------------------------------------------
// Парсит команды из Ararm,Сети,ИК
void parsing_PWM() {

  if (!strncmp_P(char_parsung[2].act, PSTR("IS"),2)) return;
  uint8_t arg1=chr_to_int(char_parsung[1].act);
  uint8_t arg2=constrain(chr_to_int(char_parsung[2].act),0,100);

  if (!strncmp_P(char_parsung[0].act, PSTR("P_OF"),4)) PWM(PWM_PIN,0); else
  if (!strncmp_P(char_parsung[0].act, PSTR("P_ON"),4)) PWM(PWM_PIN,100); else
  if (!strncmp_P(char_parsung[0].act, PSTR("ON_OF"),5) ||
      !strncmp_P(char_parsung[0].act, PSTR("SW"),2) ||
      !strncmp_P(char_parsung[0].act, PSTR("P_SW"),4)) {
      ON_OFF=!ON_OFF;
      PWM(PWM_PIN,(ON_OFF)?0:100); 
      } else
  if (!strncmp_P(char_parsung[0].act, PSTR("PWM"),3) ||
      !strncmp_P(char_parsung[0].act, PSTR("Ш"),2))
        if (arg1<=PWM_PIN) { 
          if (!strncmp_P(char_parsung[2].act, PSTR("+"),1)) PWM_inc(arg1,1); else
          if (!strncmp_P(char_parsung[2].act, PSTR("-"),1)) PWM_inc(arg1,-1); else
          if (!strncmp_P(char_parsung[2].act, PSTR("OF"),2)) PWM(arg1,0); else
          if (!strncmp_P(char_parsung[2].act, PSTR("ON"),2)) PWM(arg1,100); else
          PWM(arg1,arg2);
      }
}
//--------------------------------------------------------

void HUB_module_pult_PWM(gh::Builder& b) {
  char arg1[6]; 
  char arg2[40]; 
#ifndef WS2812_PIN
  b.beginRow();  
  if (b.Slider_("BRI",&BRI).label(F("BRI")).range(0, 100, 1).size(3).click()) PWM(PWM_PIN, BRI);
  b.endRow(); 
#endif
  b.beginRow(); 
  FOR_i(0,PWM_PIN) {
     sprintf_P(arg1, (const char *)F("PWM%d"), i);
     sprintf_P(arg2, (const char *)F("ШИМ  %d, PWM %d  пин, 0-100%"), i, pin_pwm[i]);
     if (b.Slider_(arg1,&signal_pwm[i]).label(arg2).range(0, 100, 1).color(GH::Colors::Yellow).click())  PWM(i, signal_pwm[i]) ;
  }
  b.endRow();  
}
//--------------------------------------------------------
void get_PWM() {
 char send_udp[25];
 FOR_i(0,PWM_PIN) {
    Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
    sprintf_P(send_udp, (const char *)F("PWM %d IS %d"), i, real_pwm[i]);
    Udp.print(send_udp);
    Udp.endPacket();
 }   
}  

#endif
