#if defined (MAX_LD2410)

#define LD2410_BAUD_RATE 256000

#include "MyLD2410.h"

MyLD2410 sensor(sensorSerial);

uint32_t ld_2410_stationary=0;
uint32_t ld_2410_moving=0;
uint32_t ld_2410_distance=0;

uint32_t ld_2410_old_stationary=0;
uint32_t ld_2410_old_moving=0;
uint32_t ld_2410_old_distance=0;

uint8_t ld_2410_stationary_t=0;
uint8_t ld_2410_moving_t=0;
uint8_t ld_2410_old_stationary_t=0;
uint8_t ld_2410_old_moving_t=0;

bool radarConnected = false;

#define LD2410_Menu "выкл;нет присутствия;присутствие до;движение до"
//    uint8_t choice  0  ;       1       ;       2      ;     3
//--------------------------------------------------------
struct struct_ld_2410{
//4
  uint32_t time_from=0;
  uint32_t time_to=0;
  uint32_t distance;          // Дистанция в сантиметрах
//2
  GH::Flags week=255;
  GH::Flags lamp=0;
  GH::Flags modul=0;
//1
  bool follow;
  uint8_t choice;
  bool ok=true;
  char cmd_on[CMD_LEN];       // Посылаемая команда при выполнении условия
  char cmd_on_rep[CMD_LEN];   // Посылаемая команда во время сработки
};
struct_ld_2410 ld_2410[MAX_LD2410];
FS_(ld_2410);

//--------------------------------------------------------
void setup_ld_2410(){
#if defined(ESP32)
//  sensorSerial.begin(LD2410_BAUD_RATE);
  sensorSerial.begin(LD2410_BAUD_RATE, SERIAL_8N1, RX_PIN, TX_PIN);
#else
  sensorSerial.begin(LD2410_BAUD_RATE, SERIAL_8N1);
//  sensorSerial.begin(LD2410_BAUD_RATE, SERIAL_8N1, RX_PIN, TX_PIN);
#endif
  
  FS_LOAD(ld_2410); 
  strcat(main_menu, LD2410_MENU);
  strcat(main_menu, ";");
  delay(2000);
  sensorSerial.begin(LD2410_BAUD_RATE);
  sensor.begin();
}
//--------------------------------------------------------
/*
void get_ld_2410() {
    char send_udp[25];
    Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
    sprintf_P(send_udp, (const char *)F("ld_2410 IS %s"), (ld_2410_s) ? "ON":"OFF");
    Udp.print(send_udp);
    Udp.endPacket();
} 
*/ 
//--------------------------------------------------------
void ld_2410_send(uint8_t i, char cmd[]) {
  all_parsig(ld_2410[i].lamp,ld_2410[i].modul,cmd);
}
//--------------------------------------------------------
void action_ld_2410(uint8_t i) {
  if (ld_2410[i].ok) if (strlen(ld_2410[i].cmd_on)) {  //запуск таймера
     all_parsig(ld_2410[i].lamp,ld_2410[i].modul,ld_2410[i].cmd_on);
     ld_2410[i].ok=false;
    }
  if (strlen(ld_2410[i].cmd_on_rep)) {  //запуск таймера
     all_parsig(ld_2410[i].lamp,ld_2410[i].modul,ld_2410[i].cmd_on_rep);
    }
}

//--------------------------------------------------------
void loop_ld_2410(){
  static uint32_t lastReading = 0;
//  radar.read();
  bool sensor_status;

  if((sensor.check() == MyLD2410::Response::DATA) && (millis() - lastReading > 1000)) { //Report every 1000ms
    lastReading = millis();
    
    
    ld_2410_distance=0;
    ld_2410_distance=sensor.detectedDistance();

    ld_2410_moving_t     = sensor.movingTargetSignal();
//    if( (ld_2410_moving_t>0) && sensor.movingTargetDetected())
    if (ld_2410_moving_t>1)
         ld_2410_moving = sensor.movingTargetDistance();
    else ld_2410_moving=0;     

    ld_2410_stationary_t = sensor.stationaryTargetSignal();
    if((ld_2410_stationary_t>0) && sensor.stationaryTargetDetected()) 
         ld_2410_stationary = sensor.stationaryTargetDistance();
    else ld_2410_stationary=0;

    
  FS_TICK(ld_2410); 
  bool follow=true;   
  FOR_i(0,MAX_LD2410)
   if (ld_2410[i].choice) {
       bool on_time=is_time(ld_2410[i].time_from,ld_2410[i].time_to);
       if (follow && on_time && ld_2410[i].week.get(dayofweek))
          switch (ld_2410[i].choice) {
            case 1: if (ld_2410_stationary==0) {
                       action_ld_2410(i); 
                       follow=ld_2410[i].follow; 
                    } else ld_2410[i].ok=true; 
                    break;
            case 2: if ((ld_2410_stationary>0) && (ld_2410_stationary<ld_2410[i].distance)) {
                       action_ld_2410(i); 
                       follow=ld_2410[i].follow; 
                       #ifndef GH_NO_MQTT // Отсылка значений на MQTT сервер
                       if (ld_2410_stationary) hub.sendGet("LD2410", true);
                       #endif
                    } else ld_2410[i].ok=true; 
                    break;
            case 3: if ((ld_2410_moving>0) && (ld_2410_moving<ld_2410[i].distance)) {
                       action_ld_2410(i); 
                       follow=ld_2410[i].follow; 
                    } else ld_2410[i].ok=true; 
                    break;
          } else ld_2410[i].ok=true;
     }
  #ifndef GH_NO_MQTT // Отсылка значений на MQTT сервер
    if (ld_2410_stationary != ld_2410_old_stationary) {
      hub.sendGet("ld_2410_stationary", ld_2410_stationary);
      if (hub.focused())
         hub.update("ld_2410_stationary").value(ld_2410_stationary);  // обновляем светодиод датчика движения ld_2410
      if (!ld_2410_stationary) hub.sendGet("LD2410", false);
      ld_2410_old_stationary=ld_2410_stationary;
    }
    if (ld_2410_moving != ld_2410_old_moving){
      hub.sendGet("ld_2410_moving", ld_2410_moving);
      if (hub.focused())
         hub.update("ld_2410_moving").value(ld_2410_moving);  // обновляем светодиод датчика движения ld_2410
     ld_2410_old_moving = ld_2410_moving;
    }

    if (ld_2410_distance != ld_2410_old_distance){
      hub.sendGet("ld_2410_distance", ld_2410_distance);
      if (hub.focused())
         hub.update("ld_2410_distance").value(ld_2410_distance);  // обновляем светодиод датчика движения ld_2410
     ld_2410_old_distance = ld_2410_distance;
    }

    if (ld_2410_stationary_t != ld_2410_old_stationary_t) {
      hub.sendGet("ld_2410_stationary_t", ld_2410_stationary_t);
      if (hub.focused())
         hub.update("ld_2410_stationary_t").value(ld_2410_stationary_t);  // обновляем светодиод датчика движения ld_2410
      ld_2410_old_stationary_t=ld_2410_stationary_t;
    }
    if (ld_2410_moving_t != ld_2410_old_moving_t){
      hub.sendGet("ld_2410_moving_t", ld_2410_moving_t);
      if (hub.focused())
         hub.update("ld_2410_moving_t").value(ld_2410_moving_t);  // обновляем светодиод датчика движения ld_2410
     ld_2410_old_moving_t = ld_2410_moving_t;
    }
  
  #endif
  } //1000 мс
}
//--------------------------------------------------------
/*
  stationary=0;
  moving=0;
*/
void HUB_module_LD2410(gh::Builder& b) {
  static uint8_t plus_minus[MAX_LD2410];
  static uint8_t tab = 0;
  char arg1[100];
  b.beginRow();  // начать
//  b.Label_(F("ld_2410_distance")).value(ld_2410_distance).label(F("Дистанция"));
  b.Label_(F("ld_2410_stationary")).value(ld_2410_stationary).label(F("Присутствие")).size(1);
  b.Label_(F("ld_2410_moving")).value(ld_2410_moving).label(F("Движение"));
//  b.endRow();  // ВАЖНО НЕ ЗАБЫТЬ ЕГО ЗАВЕРШИТЬ
//  b.beginRow();  // начать
  b.Label_(F("ld_2410_stationary_t")).value(ld_2410_stationary_t).label(F("Массса присутствия")).size(1);
  b.Label_(F("ld_2410_moving_t")).value(ld_2410_moving_t).label(F("Массса движения"));
  b.endRow();  // ВАЖНО НЕ ЗАБЫТЬ ЕГО ЗАВЕРШИТЬ
  FOR(tab,0,MAX_LD2410) {
    b.beginRow();  
    eeprom_flag |= b.Select(&ld_2410[tab].choice).text(LD2410_Menu).size(5).click();
    eeprom_flag |= b.Input(&ld_2410[tab].distance).label(F("Значение (см.)")).size(2).click();
    eeprom_flag |= b.Switch(&ld_2410[tab].follow).size(2).label("follow next").click();
    if (b.Tabs(&plus_minus[tab]).text(F("- ; +")).size(2).click()) b.refresh();
    b.endRow();  
    if (plus_minus[tab]) { 
       eeprom_flag |= b.Flags(&ld_2410[tab].week).text(str_dayofweek).label(F("Дни недели")).click();
       b.beginRow();  
       eeprom_flag |= b.Time(&ld_2410[tab].time_from).label(F("От")).click();
       eeprom_flag |= b.Time(&ld_2410[tab].time_to).label(F("До")).click();
       b.endRow();  
       eeprom_flag |= b.Input(ld_2410[tab].cmd_on).maxLen(HUB_LEN).label(F("Команда при сработке")).click();
       eeprom_flag |= b.Input(ld_2410[tab].cmd_on_rep).maxLen(HUB_LEN).label(F("Команда во время сработки")).click();
       eeprom_flag |= b.Flags(&ld_2410[tab].lamp).text(str_GHflags_IP).label(F("Устройства IP")).click();
       eeprom_flag |= b.Flags(&ld_2410[tab].modul).text(str_modul).label(hlp_modul).click();
    }
  }
  /*
  String str1=sensor.getFirmware();
  String str3=sensor.getMACstr();
  sprintf_P(arg1, (const char *)F("Firmware: %s \nProtocol version: %u\nBluetooth MAC : %s"), 
     str1.c_str(),
     sensor.getVersion(),
     str3.c_str());
  b.Display(arg1).label(F("Модуль")).fontSize(16).rows(4);
*/
  if (eeprom_flag) {
      FS_UPDATE(ld_2410);
      eeprom_flag=false;
   }
}

//--------------------------------------------------------
#endif
