//Модуль упраление ИК пультом

#if defined (IR_PIN)
/*
#ifdef ESP8266
#endif
#ifdef ESP32
  #include <IRRemoteESP32.h>
  IRRemoteESP32 results_ir(IR_PIN);
#endif
*/

  #include <IRremoteESP8266.h>
  #include <IRrecv.h>
  IRrecv irrecv_ir(IR_PIN);
  decode_results results_ir;


//--------------------------------------------------------
struct struct_IR_pult{
  bool on_off;
  char cmd[CMD_LEN]; // Посылаемая команда
  uint32_t code=0;
  GH::Flags lamp=0;
  GH::Flags modul=0;
  GH::Flags timers=0;
  bool repeat;
};

struct_IR_pult IR_pult[MAX_IR];
FS_(IR_pult);
//--------------------------------------------------------

int64_t IR_last_press;
int64_t IR_press;
char IR_Action[CMD_LEN];
char IR_str[]="0xFFFFFFFF";
bool pressed;

//--------------------------------------------------------
void setup_IR(){
  irrecv_ir.enableIRIn();
  FS_LOAD(IR_pult); 
  strcat(main_menu, IR_MENU);
  strcat(main_menu, ";");
}

//--------------------------------------------------------
void loop_IR() {
  FS_TICK(IR_pult); 
  char arg1[10]; 
  /*
#ifdef ESP32
  int resultirRemote.checkRemote();
#endif
#ifdef ESP8266
#endif
*/
  if ( irrecv_ir.decode( &results_ir )) {   // если данные пришли
      ultoa(results_ir.value,IR_str,16);
      if (results_ir.value != -1) {
         pressed=false;
         IR_press=results_ir.value;
         FOR_i(0,MAX_IR) {
          //Записать команду в свободную включенную ячейку
           if (IR_pult[i].on_off)
            if (IR_pult[i].code==0) {
              IR_pult[i].code=IR_press;
              FS_UPDATE(IR_pult);
              if (hub.focused()) {
                  sprintf_P(arg1, (const char *)F("code%d"), i);
                  hub.update(arg1).value(IR_str);
                  HUB_Update=false;
              }
            }
         }
      } else IR_press=-1;
      FOR_j(0,MAX_IR) {
           if (IR_pult[j].on_off) {
              if (IR_press==-1) IR_press=IR_last_press;
              if ((IR_pult[j].code==IR_press) || (IR_pult[j].code==0xFFFFFFFF)) {
                if (IR_pult[j].repeat) IR_last_press = IR_press; else IR_last_press = -1;

                  if (!strcmp(IR_Action,"IRx"))  sprintf_P(IR_Action,"IRx %x",IR_press); else
                  if (!strcmp(IR_Action,"IR"))   sprintf_P(IR_Action,"IR %u",IR_press); else
                  if (!strcmp(IR_Action,"433x"))  sprintf_P(IR_Action,"433x %x",IR_press); else
                  if (!strcmp(IR_Action,"433"))   sprintf_P(IR_Action,"433 %u",IR_press); else
                  strcpy(IR_Action, IR_pult[j].cmd);

                  all_parsig(IR_pult[j].lamp,IR_pult[j].modul,IR_Action);
              }
           }   
      }
    irrecv_ir.resume();  // принимаем следующую команду
  }
}
//--------------------------------------------------------
void HUB_module_IR(gh::Builder& b) {
  static uint8_t plus_minus[MAX_IR];
  static uint8_t tab = 0;


 FOR(tab,0,MAX_IR) { 
  b.beginRow();  
  char arg1[10]; 
  sprintf_P(arg1, (const char *)F("sw_IR%d"), tab);
  eeprom_flag |= b.Switch_(arg1,&IR_pult[tab].on_off).label(F("Active")).size(1).click();
  sprintf_P(arg1, (const char *)F("code%d"), tab);
  char IR_HEX[15];
  ultoa(IR_pult[tab].code,IR_HEX,16);
  if (b.Input_(arg1,IR_HEX).label(F("HEX Code")).maxLen(8).regex(F("^[A-Fa-f0-9]+$")).size(2).click()) {
      IR_pult[tab].code = strtoul(IR_HEX, 0, 16);
      eeprom_flag=true;
  }
  eeprom_flag |= b.Switch(&IR_pult[tab].repeat).label(F("Повтор 0xFFFFFF")).size(1).click();
  if (b.Tabs(&plus_minus[tab]).text(F("- ; +")).size(1).click()) b.refresh();
  b.endRow();  
  if (plus_minus[tab]) {
    eeprom_flag |= b.Input(IR_pult[tab].cmd).maxLen(HUB_LEN).label(F("Акция IR пульта")).click();
    eeprom_flag |= b.Flags(&IR_pult[tab].lamp).text(str_GHflags_IP).label(F("Устройства IP")).click();
    eeprom_flag |= b.Flags(&IR_pult[tab].modul).text(str_modul).label(hlp_modul).click();
  }
 }  
     if (eeprom_flag) {
      FS_UPDATE(IR_pult);
      eeprom_flag=false;
   }
}
//--------------------------------------------------------
#endif
