#if defined (DHT_PIN)

#define DHT_Menu "выкл;температура >;температура <;влажность >;влажность <"

#include "DHT.h"

DHT dht(DHT_PIN, DHT22);
float humidity;
float temperature;

//--------------------------------------------------------
struct struct_DHT_22{
  bool on_off;
  char cmd_on[CMD_LEN];       // Посылаемая команда при сработке
  char cmd_on_rep[CMD_LEN];   // Посылаемая команда во время сработки
  int16_t h_t;           // температура / влажность для сравнения
  uint8_t choice;        // 0 - нет выбора, 1 - t>, 2 - t<, 3 - h>, 4 - h<
  uint32_t time_from=0;
  uint32_t time_to=0;
  GH::Flags week=0;
  GH::Flags lamp=0;
  GH::Flags modul=0;
  bool ok=true;
};
struct_DHT_22 DHT_22[MAX_DHT_22];
FS_(DHT_22);


//--------------------------------------------------------
void setup_DHT_22(){
  FS_LOAD(DHT_22); 
  dht.begin();
  strcat(main_menu, DHT_MENU);
  strcat(main_menu, ";");
  delay(1000);
}

//--------------------------------------------------------
void action_DHT(uint8_t i) {
  if (DHT_22[i].ok) if (strlen(DHT_22[i].cmd_on)) {  //запуск таймера
     all_parsig(DHT_22[i].lamp,DHT_22[i].modul,cmd_on);
     DHT_22[i].ok=false;
    }
  if (strlen(DHT_22[i].cmd_on_rep)) {  //запуск таймера
     all_parsig(DHT_22[i].lamp,DHT_22[i].modul,cmd_on_rep);
    }
}
//--------------------------------------------------------
void loop_DHT_22(){
  FS_TICK(DHT_22); 
  char arg1[10];
  EVERY_MS(10000) { 
     humidity = dht.readHumidity(); //Измеряем влажность
     temperature = dht.readTemperature(); //Измеряем температуру
     
//     humidity = 45.553;
//     temperature = 22.333;
     if (hub.focused() && HUB_Update) {
       sprintf_P(arg1, (const char *)F("%.2f °"), temperature);
       hub.update("temperature").value(arg1);
       sprintf_P(arg1, (const char *)F("%.2f 🜁"), humidity);
       hub.update("humidity").value(arg1);
       HUB_Update=false;
     }
     #ifndef GH_NO_MQTT
     //---------------------------------
     // Отсылка значений на MQTT сервер
       hub.sendGet("temperature", temperature, 2);
       hub.sendGet("humidity", humidity, 2);
     //---------------------------------
     #endif
     FOR_i(0,MAX_DHT_22) if (DHT_22[i].choice) {
       bool on_time=is_time(DHT_22[i].time_from,DHT_22[i].time_to);
       if (on_time && DHT_22[i].week.get(dayofweek)) switch (DHT_22[i].choice) {
         case 1: if (temperature>DHT_22[i].h_t) action_DHT(i);  break;
         case 2: if (temperature<DHT_22[i].h_t) action_DHT(i);  break;
         case 3: if (humidity>DHT_22[i].h_t) action_DHT(i);     break;
         case 4: if (humidity<DHT_22[i].h_t) action_DHT(i);     break;
       } else DHT_22[i].ok=true;
     }
  }  
}
//--------------------------------------------------------
void parsing_DHT_22(char act_chr[]){

}
//--------------------------------------------------------
void HUB_module_DHT_22(gh::Builder& b) {
  static uint8_t plus_minus[MAX_DHT_22];
  static uint8_t tab = 0;
  char arg1[10];
  b.beginRow();  // начать
  sprintf_P(arg1, (const char *)F("%.2f °"), temperature);
  b.Label_(F("temperature")).value(arg1).label(F("Температура")).size(1);
  sprintf_P(arg1, (const char *)F("%.2f  🜁"), humidity);
  b.Label_(F("humidity")).value(arg1).label(F("Влажность"));
  b.endRow();  // ВАЖНО НЕ ЗАБЫТЬ ЕГО ЗАВЕРШИТЬ
  FOR(tab,0,MAX_DHT_22) {
    b.beginRow();  
    eeprom_flag |= b.Select(&DHT_22[tab].choice).text(DHT_Menu).size(5).click();
    eeprom_flag |= b.Input(&DHT_22[tab].h_t).label(F("Значение")).size(3).click();
    if (b.Tabs(&plus_minus[tab]).text(F("- ; +")).size(2).click()) b.refresh();
    b.endRow();  
    if (plus_minus[tab]) { 
       eeprom_flag |= b.Flags(&DHT_22[tab].week).text(str_dayofweek).label(F("Дни недели")).click();
       b.beginRow();  
       eeprom_flag |= b.Time(&DHT_22[tab].time_from).label(F("От")).click();
       eeprom_flag |= b.Time(&DHT_22[tab].time_to).label(F("До")).click();
       b.endRow();  
       eeprom_flag |= b.Input(DHT_22[tab].cmd_on).maxLen(HUB_LEN).label(F("Команда при сработке")).click();
       eeprom_flag |= b.Input(DHT_22[tab].cmd_on_rep).maxLen(HUB_LEN).label(F("Команда во время сработки")).click();
       eeprom_flag |= b.Flags(&DHT_22[tab].lamp).text(str_GHflags_IP).label(F("Устройства IP")).click();
       eeprom_flag |= b.Flags(&DHT_22[tab].modul).text(str_modul).label(hlp_modul).click();
    }
  }
  if (eeprom_flag) {
      FS_UPDATE(DHT_22);
      eeprom_flag=false;
   }
}
//--------------------------------------------------------
void load_DHT_22(){

}
#endif
