#if defined (DFPlayer)

#include <Arduino.h>
#include <SoftwareSerial.h>

SoftwareSerial mp3(MP3_RX_PIN, MP3_TX_PIN); // RX, TX

//буффер команд
//uint8_t cmdbuf[9] = {0x7E, 0xFF, 06, 00, 01, 00, 00, 0xEF, 0};
char cmdbuf[9] = {0x7E, 0xFF, 06, 00, 00, 00, 00, 0xEF, 0};
uint8_t ansbuf[10] = {0};
uint8_t mp3_folders=0;
uint8_t mp3_status=0;
uint8_t mp3_volume=1;
uint16_t mp3_files=0;
char chr_ansver[50];

void command(int8_t cmd, int8_t dat5, int8_t dat6)
{
  // Посылка команды MP3 плееру
  cmdbuf[3] = cmd;  // polecenie
  cmdbuf[5] = dat5; // parametr DAT1
  cmdbuf[6] = dat6; // parametr DAT2
  FOR_i(0,8) {
    mp3.write(cmdbuf[i]);
    delay(3);
  }
}

boolean answer(void)
  // Ответ от MP3 плеера
{
  uint8_t i;
  uint8_t b = 0;
  while(mp3.available() && (b!=0x7E))
  {
    b = mp3.read();
    delay(5);
  }
  ansbuf[0] = b;
  i = 1;
  while(mp3.available() && (i < 10))
  {
    b = mp3.read();
    ansbuf[i] = b;
    i++;
    delay(5);
  }
  if ((ansbuf[0] == 0x7E) && (ansbuf[9] == 0xEF))
  {
    sprintf_P(chr_ansver, (const char *)F("%02X %02X %02X %02X %02X %02X %02X %02X %02X %02X"), 
    ansbuf[0],    ansbuf[1],    ansbuf[2],    ansbuf[3],    ansbuf[4],
    ansbuf[5],    ansbuf[6],    ansbuf[7],    ansbuf[8],    ansbuf[9]);
    if (hub.focused()) {
      hub.update("DFP_ANS").value(chr_ansver);
    }
    return true;
  }
 
  return false;
}

//--------------------------------------------------------
void WhiteAnswer() {
 uint32_t timer_1=millis();
 while ((not mp3.available()) && (millis()-timer_1<2000)) delay(5);
}

//--------------------------------------------------------
void setup_DFPlayer() {
  strcat(main_menu, DFP_MENU);
  strcat(main_menu, ";");
  DEBUGLN("Start MP3 Player");
  mp3.begin(9600);
  delay(1000);
  command(0x0C, 0, 0);  // reset
  delay(1000);
  command(0x09, 0, 2);  // Выбор TF
  delay(1000);
  command(0x06, 0, mp3_volume);  // Громкость
  delay(300);
}
//--------------------------------------------------------
void loop_DFPlayer() {
static uint8_t sss=0;
bool ans=false;
 {EVERY_MS(10000) {
  switch (sss) {
//    case 0: command(0x42,0,0); break; // статус stop / play / pause
//    case 1: command(0x44,0,0); break; // эквалайзер
//    case 2: command(0x43,0,0); break; // громкость
//    case 3: if (!mp3_files) command(0x48,0,0); break; // количество файлов 
//    case 4: command(0x4c,0,0); break; //Текущий файл TF 
//    case 5: command(0x4f,0,0); break; //Общее количество папок 
  }
  sss = (sss+1) % 6;
 }} 
 {EVERY_MS(500) {
  ans=answer();
  if (ans) {
    
    if (ansbuf[4]==0x42) mp3_status=ansbuf[6];
    if (ansbuf[4]==0x4f) mp3_folders=256*ansbuf[5]+ansbuf[6];
    if (ansbuf[4]==0x43) {
      mp3_volume=ansbuf[6];
    }
    if (ansbuf[4]==0x48) mp3_files=256*ansbuf[5]+ansbuf[6];
  }
 }}
 {EVERY_MS(10000)  if (rassvet) {
  if (mp3_volume<map(rassvet,0,255,1,MAX_VOL_DOWN))
     {
       mp3_volume=map(rassvet,0,255,1,MAX_VOL_DOWN);
       command(0x06,0,mp3_volume); 
       delay(100);
     }
 }}
}
//--------------------------------------------------------
// Парсит команды из Ararm,Сети,ИК

void parsing_DFPlayer() {
  DEBUG("parsing_DFPlayer: ");
  DEBUGLN(char_parsung[0].act);
  if (!strcmp_P(char_parsung[0].act, PSTR("DAWN")) ||
      !strcmp_P(char_parsung[0].act, PSTR("Рассвет"))) {
       mp3_status=1;
       mp3_volume=1;
       command(0x06,0,mp3_volume); 
#ifdef DAWN_FOLDER
       delay(100);
       command(0x17,0,DAWN_FOLDER); // folder
#else
       delay(100);
       command(0x18,0,0); // all folder random
#endif
//       delay(100);
//       command(0x0D,0,0); //Play
       DEBUGLN("MP3 Рассвет");
       return;
     } 

  if (!strcmp_P(char_parsung[0].act, PSTR("P_ON")) ||
      !strcmp_P(char_parsung[0].act, PSTR("PLAY"))) {
      mp3_status=1;
      command(0x0D,0,0); 
      return;
    } 

  if (!strncmp_P(char_parsung[0].act, PSTR("P_OF"),4) ||
      !strcmp_P(char_parsung[0].act, PSTR("STOP"))) {
      mp3_status=0;
      command(0x16,0,0);
      return;
    } 

  if (!strcmp_P(char_parsung[0].act, PSTR("NEXT"))) {
      command(0x01,0,0);
      return;
    } 
  
  if (!strncmp_P(char_parsung[0].act, PSTR("PREV"),4)) {
      command(0x02,0,0);
      return;
    } 

  if (!strncmp_P(char_parsung[0].act, PSTR("PAUSE"),5)) {
      mp3_status=2;
      command(0x0E,0,0);
      return;
    } 

  if (!strncmp_P(char_parsung[0].act, PSTR("ON_OFF"),6) ||
      !strncmp_P(char_parsung[0].act, PSTR("SW"),2) ||
      !strncmp_P(char_parsung[0].act, PSTR("P_SW"),4)) {
      mp3_status=mp3_status?0:1;
      if (mp3_status) command(0x0D,0,0); else command(0x16,0,0);
      return;
    } 
 
  if (!strncmp_P(char_parsung[0].act, PSTR("VOL"),3)) {
      if (!strncmp_P(char_parsung[1].act, PSTR("+"),1)) 
         { (mp3_volume<30) ? mp3_volume++ : 30 ; command(0x06,0,mp3_volume);} else
      if (!strncmp_P(char_parsung[1].act, PSTR("-"),1)) 
         { (mp3_volume>0) ? mp3_volume-- : 0 ; command(0x06,0,mp3_volume);} else {
         mp3_volume=constrain(chr_to_int(char_parsung[1].act),0,30);
         command(0x06,0,mp3_volume);
         }
      return;
    } 

  if (!strncmp_P(char_parsung[0].act, PSTR("CMD"),3)) {
      uint8_t Para_MSB=chr_to_int(char_parsung[2].act);
      uint8_t Para_LSB=chr_to_int(char_parsung[3].act);
      command(strtoul(char_parsung[1].act, 0, 16),Para_MSB,Para_LSB);
/*
      char arg1[10];
      char arg2[10];
      sprintf_P(arg1, (const char *)F("%s %d %d"), char_parsung[1].act, Para_MSB, Para_LSB);
      hub.sendUpdate("DFP_ANS", arg1);
*/
      return;
    } 

}
//--------------------------------------------------------
void show_player(gh::Builder& b) {
    b.beginRow(); 
    if (b.Button(0).icon(F("⏪")).label(F("Prev")).size(2).click())  command(0x02,0,0);    // ⏪ f048
    if (b.Button(0).icon(F("⏹")).label(F("Stop")).size(2).click())  command(0x16,0,0);    // ⏹ f04d или f0c8 или f45c
    if (b.Button(0).icon(F("▶")).label(F("Play")).size(3).click())  command(0x0D,0,0);     // ▶ f04b или f0da или f152
    if (b.Button(0).icon(F("⏸")).label(F("Pause")).size(2).click()) command(0x0E,0,0);  // ⏸ f04c или f28b
    if (b.Button(0).icon(F("⏩")).label(F("Next")).size(2).click())  command(0x01,0,0);    // ⏩ f051
    b.endRow();
    if (b.Slider_("VOL",&mp3_volume).label(F("Громкость")).range(0,30,1).click()) command(0x06,0,mp3_volume);
}
//--------------------------------------------------------
void HUB_module_pult_DFPlayer(gh::Builder& b) {
  show_player(b);
}

//--------------------------------------------------------
void HUB_module_DFPlayer(gh::Builder& b) {
    static char cmd_mp3[CMD_LEN];
    show_player(b);
//    if (b.Input(cmd_mp3).label(F("Команда для DFPlayer")).maxLen(HUB_LEN).click()) module_parsig(16,cmd_mp3):
    //parsing_DFPlayer(cmd_mp3);
    b.Input_("DFP_ANS",chr_ansver).label(F("Ответ от DFPlayer"));
}

//--------------------------------------------------------
void get_DFPlayer() {
  char send_udp[25];
  Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
  sprintf_P(send_udp, (const char *)F("DFP IS %s"), mp3_status==0?"STOP":mp3_status==1?"PLAY":"PAUSE");
  Udp.print(send_udp);
  Udp.endPacket();
}  

#endif
