void module_setup() {
  /* Модули с меню 
   *  PULT - 0
   *  IP - 1
   *  Остальные номера задаются по порядку
   */
    #if defined (IR_PIN)
      setup_IR(); 
    #endif
    #if defined (TX_IR_PIN)
      setup_TX_IR(); 
    #endif
    #if defined (RX433_PIN)
      setupRX433(); 
    #endif
    #if defined (TX433_PIN)
      setup_TX433();
    #endif
    #if defined (SR501_PIN)
      setup_SR501();
    #endif
    #if defined (WS2812_PIN)
      setup_WS2812();
    #endif
    #if defined (MAX_TIMER)
      setup_TIMER();
      char stertup[]="STARTUP\0";
      split_parsing(stertup);
      // Запустить таймеры с  именем "STARTUP"
      parsing_TIMER(stertup);  
    #endif
    #if defined (DHT_PIN)
      setup_DHT_22();
    #endif
    #if defined (MAX_ALARMS)
      setup_Alarms();
    #endif
    #if defined (BTN_PIN)
      setup_G_Button();
    #endif
    #if defined (MAX_LD2410)
      setup_ld_2410();
    #endif
    #if defined (MAX_SENDS)
      setup_SENDS();
      strcat(main_menu, "Trans;");
    #endif
    #if defined (DFPlayer)
      setup_DFPlayer();
    #endif

//--------------------------------------------------------
    strcat(main_menu, "-?-");
  
  // Модули без меню
    #if defined (RELE_PIN)
      setup_G220();
    #endif
    #if defined (PWM_PIN)
      setup_PWM();
    #endif
    #if defined (GyverLamp)
      setup_GyverLamp();
    #endif
    
}
//--------------------------------------------------------
void module_loop() {
    //DEBUG("Task running on core ");    DEBUGLN(xPortGetCoreID());
    #if defined (MAX_ALARMS)
      loop_Alarms();
      yield();
    #endif
    #if defined (IR_PIN)
      loop_IR();
    #endif
    #if defined (RX433_PIN)
      loopRX433();
    #endif
    #if defined (RELE_PIN)
      loop_G220();
    #endif
    #if defined (SR501_PIN)
      loop_SR501();
      yield();
    #endif
    #if defined (MAX_SENDS)
      loop_SENDS();
    #endif
    #if defined (GyverLamp)
      loop_GyverLamp();
    #endif
    #if defined (PWM_PIN)
      loop_PWM();
    #endif
    #if defined (MAX_TIMER)
      loop_TIMER();
      yield();
    #endif
    #if defined (WS2812_PIN)
      loop_WS2812();
      yield();
    #endif
    #if defined (DHT_PIN)
      loop_DHT_22();
      yield();
    #endif
    #if defined (BTN_PIN)
      loop_G_Button();
    #endif
    #if defined (DFPlayer)
      loop_DFPlayer();
    #endif
    #if defined (MAX_LD2410)
      loop_ld_2410();
    #endif
}
//--------------------------------------------------------
void module_get() {
    #if defined (RELE_PIN)
      get_G220();  
    #endif
    #if defined (PWM_PIN)
      get_PWM();  
    #endif
    #if defined (SR501_PIN)
      get_SR501();
    #endif
    #if defined (DFPlayer)
      get_DFPlayer();
    #endif
    #if defined (WS2812_PIN)
      get_WS2812();
    #endif
}
//--------------------------------------------------------
void all_parsig(GH::Flags f_ip,GH::Flags f_mod,char act1[]) {
  char act[CMD_LEN];
  strcpy(act, act1);
  if (strchr(act,'@')!=NULL) {
      char chr_cmd[CMD_LEN]={0};
      strncpy(chr_cmd,act,strcspn(act, "@"));
      int32_t int_arg=chr_to_int(strchr(act, '@')+1); 
      sprintf_P(act, chr_cmd, int_arg); 
    }
  if (f_ip.flags)  IP_parsig(f_ip,act);
  if (f_mod.flags) module_parsig(f_mod,act);
  DEBUGLN(act);
}

void IP_parsig(GH::Flags mod,char act[]) {
    FOR_i(0,MAX_IP)  
      if (mod.get(i))
       if (ip_addr[i].on_off) send_console(ip_addr[i].ipchr,act);
}
//--------------------------------------------------------
// Разделение аргументов на массив char

void split_parsing(char act[]) {
 FOR_i(0,MAX_ARG) {
  FOR_j(0,CMD_LEN)
   char_parsung[i].act[j]=0;
   char_parsung[i].len=0;
 }
 uint8_t j=0;
 FOR_i(0,strlen(act)) {
   if (act[i]==' ') j++; else {
     char _sym[2]={0};
     _sym[0]=toupper(act[i]);
     if (j<MAX_ARG) strcat(char_parsung[j].act,_sym);
   }
 }
 del_str_parsing();
 FOR_i(0,MAX_ARG) {
  char_parsung[i].len=strlen(char_parsung[i].act);
 }
}
// Удаление нулевого аргумента со сдвигом
void del_parsing() {
 FOR_i(0,MAX_ARG-1) {
  strcpy(char_parsung[i].act,char_parsung[i+1].act);
  char_parsung[i].len=strlen(char_parsung[i].act);
 }
 FOR_i(0,CMD_LEN) char_parsung[MAX_ARG-1].act[i]=0;
 char_parsung[MAX_ARG-1].len=0;
}
// Удаление паразитных слов от Кузи
void del_str_parsing() {
    if (!strncmp_P(char_parsung[0].act, PSTR("включить"),16)) del_parsing();
    if (!strncmp_P(char_parsung[0].act, PSTR("включи"),12))   del_parsing();
    if (!strncmp_P(char_parsung[0].act, PSTR("эффект"),12))   del_parsing();
    if (!strncmp_P(char_parsung[0].act, PSTR("канал"),10))    del_parsing();
    if (!strncmp_P(char_parsung[0].act, PSTR("кузя"),8))     del_parsing();
} 
   
//--------------------------------------------------------
void module_parsig(GH::Flags mod,char act[]) {
    split_parsing(act);
    //------------------------------ Виртуальные кнопки
    #ifndef GH_NO_MQTT // Отсылка значений на MQTT сервер
      char arg1[15]="BTN";
     if (!strncmp_P(act, PSTR("1BTN"), 4)) {
      DEBUGLN("BTN");
      strncat(arg1, char_parsung[1].act,strlen(char_parsung[1].act));
      DEBUGLN(arg1);
      hub.sendGet(arg1, 1);
      return;
     }
     if (!strncmp_P(act, PSTR("2BTN"), 4)) {
      DEBUGLN("BTN");
      strncat(arg1, char_parsung[1].act,strlen(char_parsung[1].act));
      DEBUGLN(arg1);
      hub.sendGet(arg1, 2);
      return;
     }
     if (!strncmp_P(act, PSTR("3BTN"), 4)) {
      DEBUGLN("BTN");
      strncat(arg1, char_parsung[1].act,strlen(char_parsung[1].act));
      DEBUGLN(arg1);
      hub.sendGet(arg1, 3);
      return;
     }
    #endif
//  DEBUG("module_parsig: ");
//  DEBUGLN(char_parsung[0].act);
    #if defined (MAX_TIMER)
      if (mod.get(3)) parsing_TIMER(act);  
    #endif
    if (!strncmp_P(act, PSTR("WS2812 IS "), 10))  return;
    if (!strncmp_P(act, PSTR("SR501 IS"), 8)) return; 
    if (!strncmp_P(act, PSTR("RELE 0 IS"), 9)) return; 
    if (!strncmp_P(act, PSTR("CURR "), 5)) return; 
    #if defined (WS2812_PIN)
      if (mod.get(2)) parsing_WS2812(act);  
    #endif
    if (!strncmp_P(act, PSTR("EFF"), 3)) return; 
    #if defined (RELE_PIN)
      if (mod.get(0)) parsing_G220();  
    #endif
    if (!strncmp_P(act, PSTR("RELE"), 4)) return; 
    #if defined (PWM_PIN)
      if (mod.get(1)) parsing_PWM();  
      if (!strncmp_P(act, PSTR("PWM"), 3)) return; 
    #endif
    #if defined (TX_IR_PIN)
      if (mod.get(6)) parsing_TX_IR();
    #endif
    #if defined (TX433_PIN)
      if (mod.get(5)) parsing_TX433();
    #endif
    if (!strncmp_P(act, PSTR("433"), 3)) return; 
    if (!strncmp_P(act, PSTR("IR"), 2)) return; 
    #if defined (SR501_PIN)
      parsing_SR501();
    #endif
    #if defined (DFPlayer)
      if (mod.get(4)) parsing_DFPlayer();
    #endif
    #if defined (MAX_ALARMS)
      parsing_Alarm();
    #endif
    #if defined (MAX_SENDS)
      parsing_SENDS(act);
    #endif
}
//--------------------------------------------------------
void module_pult_HUB(gh::Builder& b) {
   #if defined (GyverLamp)
       HUB_module_Pult_GyverLamp(b);
   #endif
   #if defined (RELE_PIN)
       HUB_module_pult_G220(b);
   #endif
   #if defined (PWM_PIN)
       HUB_module_pult_PWM(b);
   #endif
   #if defined (WS2812_PIN)
       HUB_module_pult_WS2812(b);
   #endif
   #if defined (MAX_TIMER)
       HUB_module_pult_TIMER(b);
   #endif
   #if defined (DFPlayer)
       HUB_module_pult_DFPlayer(b);
   #endif
   #if defined (GyverLamp)
       HUB_module_Pult_GyverLamp(b);
   #endif
}
//--------------------------------------------------------
void module_HUB(int16_t tab,gh::Builder& b) {
//--------------------------------------------------
        #if defined (MAX_ALARMS)
        if (tab == split_position(main_menu,ALARM_MENU,';')) HUB_module_Alarm(b); 
        #endif
//--------------------------------------------------
        #if defined (IR_PIN)
        if (tab == split_position(main_menu,IR_MENU,';')) HUB_module_IR(b);
        #endif
//--------------------------------------------------
        #if defined (RX433_PIN)
        if (tab == split_position(main_menu,RX433_MENU,';')) HUB_moduleRX433(b);
        #endif
//--------------------------------------------------
        #if defined (SR501_PIN)
        if (tab == split_position(main_menu,SR501_MENU,';')) HUB_module_SR501(b);
        #endif
//--------------------------------------------------
        #if defined (MAX_SENDS)
        if (tab == split_position(main_menu,"Trans",';')) HUB_module_SENDS(b);
        #endif
//--------------------------------------------------
        #if defined (MAX_TIMER)
        if (tab == split_position(main_menu,TIMER_MENU,';')) HUB_module_TIMER(b);
        #endif
//--------------------------------------------------
        #if defined (DHT_PIN)
        if (tab == split_position(main_menu,DHT_MENU,';')) HUB_module_DHT_22(b);
        #endif
//--------------------------------------------------
        #if defined (WS2812_PIN)
        if (tab == split_position(main_menu,WS2812_MENU,';')) HUB_module_WS2812(b);
        #if (WS2812_D==2)  // Матрица
        #ifdef WS2812_PAINT
        if (tab == split_position(main_menu,WS2812_PAINT,';'))  HUB_module_paint_WS2812(b);
        #endif
        #endif
        #endif
//--------------------------------------------------
        #if defined (BTN_PIN)
        if (tab == split_position(main_menu,BTN_MENU,';')) HUB_module_G_Button(b);
        #endif
//--------------------------------------------------
        #if defined (DFPlayer)
        if (tab == split_position(main_menu,DFP_MENU,';')) HUB_module_DFPlayer(b);
        #endif
//--------------------------------------------------
        #if defined (MAX_LD2410)
        if (tab == split_position(main_menu,LD2410_MENU,';')) HUB_module_LD2410(b);
        #endif
//--------------------------------------------------
}
