#!/bin/bash
export INPUT="IRtext.cpp"
export OUTPUT="IRtext.h"

if [[ ! -f ${INPUT} ]]; then
  echo "Can't read file '${INPUT}'. Aborting!"
  exit 1
fi

# Header
cat >${OUTPUT} << EOF
// Copyright 2019 - David Conran (@crankyoldgit)
// This header file is to be included in files **other than** 'IRtext.cpp'.
//
// WARNING: Do not edit this file! This file is automatically generated by
//          'tools/generate_irtext_h.sh'.

#ifndef IRTEXT_H_
#define IRTEXT_H_

#include "i18n.h"

// Constant text to be shared across all object files.
// This means there is only one copy of the character/string/text etc.

EOF

# Parse and output contents of INPUT file.
sed 's/ PROGMEM//' ${INPUT} | egrep "^(const )?char" | cut -f1 -d= |
    sed 's/ $/;/;s/^/extern /' | sort -u >> ${OUTPUT}

# Footer
cat >> ${OUTPUT} << EOF

#endif  // IRTEXT_H_
EOF
