// Copyright 2018 David Conran

#include "IRrecv.h"
#include "IRsend.h"
#include "IRsend_test.h"
#include "gtest/gtest.h"

// Tests for sendCarrierAC()

// Test sending typical data only.
TEST(TestSendCarrierAC, SendDataOnly) {
  IRsendTest irsend(0);
  irsend.begin();

  irsend.reset();
  irsend.sendCarrierAC(0x0);
  EXPECT_EQ(
      "f38000d50"
      "m8532s4228"
      "m628s532m628s532m628s532m628s532m628s532m628s532m628s532m628s532"
      "m628s532m628s532m628s532m628s532m628s532m628s532m628s532m628s532"
      "m628s532m628s532m628s532m628s532m628s532m628s532m628s532m628s532"
      "m628s532m628s532m628s532m628s532m628s532m628s532m628s532m628s532"
      "m628s20000"
      "m8532s4228"
      "m628s1320m628s1320m628s1320m628s1320m628s1320m628s1320m628s1320m628s1320"
      "m628s1320m628s1320m628s1320m628s1320m628s1320m628s1320m628s1320m628s1320"
      "m628s1320m628s1320m628s1320m628s1320m628s1320m628s1320m628s1320m628s1320"
      "m628s1320m628s1320m628s1320m628s1320m628s1320m628s1320m628s1320m628s1320"
      "m628s20000"
      "m8532s4228"
      "m628s532m628s532m628s532m628s532m628s532m628s532m628s532m628s532"
      "m628s532m628s532m628s532m628s532m628s532m628s532m628s532m628s532"
      "m628s532m628s532m628s532m628s532m628s532m628s532m628s532m628s532"
      "m628s532m628s532m628s532m628s532m628s532m628s532m628s532m628s532"
      "m628s20000",
      irsend.outputStr());
  irsend.reset();
  irsend.sendCarrierAC(0x12345678);
  EXPECT_EQ(
      "f38000d50"
      "m8532s4228"
      "m628s532m628s532m628s532m628s1320m628s532m628s532m628s1320m628s532"
      "m628s532m628s532m628s1320m628s1320m628s532m628s1320m628s532m628s532"
      "m628s532m628s1320m628s532m628s1320m628s532m628s1320m628s1320m628s532"
      "m628s532m628s1320m628s1320m628s1320m628s1320m628s532m628s532m628s532"
      "m628s20000"
      "m8532s4228"
      "m628s1320m628s1320m628s1320m628s532m628s1320m628s1320m628s532m628s1320"
      "m628s1320m628s1320m628s532m628s532m628s1320m628s532m628s1320m628s1320"
      "m628s1320m628s532m628s1320m628s532m628s1320m628s532m628s532m628s1320"
      "m628s1320m628s532m628s532m628s532m628s532m628s1320m628s1320m628s1320"
      "m628s20000"
      "m8532s4228"
      "m628s532m628s532m628s532m628s1320m628s532m628s532m628s1320m628s532"
      "m628s532m628s532m628s1320m628s1320m628s532m628s1320m628s532m628s532"
      "m628s532m628s1320m628s532m628s1320m628s532m628s1320m628s1320m628s532"
      "m628s532m628s1320m628s1320m628s1320m628s1320m628s532m628s532m628s532"
      "m628s20000",
      irsend.outputStr());

  irsend.reset();
  irsend.sendCarrierAC(0x4CCA541D);
  EXPECT_EQ(
      "f38000d50"
      "m8532s4228"
      "m628s532m628s1320m628s532m628s532m628s1320m628s1320m628s532m628s532"
      "m628s1320m628s1320m628s532m628s532m628s1320m628s532m628s1320m628s532"
      "m628s532m628s1320m628s532m628s1320m628s532m628s1320m628s532m628s532"
      "m628s532m628s532m628s532m628s1320m628s1320m628s1320m628s532m628s1320"
      "m628s20000"
      "m8532s4228"
      "m628s1320m628s532m628s1320m628s1320m628s532m628s532m628s1320m628s1320"
      "m628s532m628s532m628s1320m628s1320m628s532m628s1320m628s532m628s1320"
      "m628s1320m628s532m628s1320m628s532m628s1320m628s532m628s1320m628s1320"
      "m628s1320m628s1320m628s1320m628s532m628s532m628s532m628s1320m628s532"
      "m628s20000"
      "m8532s4228"
      "m628s532m628s1320m628s532m628s532m628s1320m628s1320m628s532m628s532"
      "m628s1320m628s1320m628s532m628s532m628s1320m628s532m628s1320m628s532"
      "m628s532m628s1320m628s532m628s1320m628s532m628s1320m628s532m628s532"
      "m628s532m628s532m628s532m628s1320m628s1320m628s1320m628s532m628s1320"
      "m628s20000",
      irsend.outputStr());
}

// Test sending typical data only.
TEST(TestSendCarrierAC, SendWithRepeats) {
  IRsendTest irsend(0);
  irsend.begin();

  irsend.reset();
  irsend.sendCarrierAC(0x12345678, kCarrierAcBits, 2);  // two repeats.
  EXPECT_EQ(
      "f38000d50"
      "m8532s4228"
      "m628s532m628s532m628s532m628s1320m628s532m628s532m628s1320m628s532"
      "m628s532m628s532m628s1320m628s1320m628s532m628s1320m628s532m628s532"
      "m628s532m628s1320m628s532m628s1320m628s532m628s1320m628s1320m628s532"
      "m628s532m628s1320m628s1320m628s1320m628s1320m628s532m628s532m628s532"
      "m628s20000"
      "m8532s4228"
      "m628s1320m628s1320m628s1320m628s532m628s1320m628s1320m628s532m628s1320"
      "m628s1320m628s1320m628s532m628s532m628s1320m628s532m628s1320m628s1320"
      "m628s1320m628s532m628s1320m628s532m628s1320m628s532m628s532m628s1320"
      "m628s1320m628s532m628s532m628s532m628s532m628s1320m628s1320m628s1320"
      "m628s20000"
      "m8532s4228"
      "m628s532m628s532m628s532m628s1320m628s532m628s532m628s1320m628s532"
      "m628s532m628s532m628s1320m628s1320m628s532m628s1320m628s532m628s532"
      "m628s532m628s1320m628s532m628s1320m628s532m628s1320m628s1320m628s532"
      "m628s532m628s1320m628s1320m628s1320m628s1320m628s532m628s532m628s532"
      "m628s20000"
      "m8532s4228"
      "m628s532m628s532m628s532m628s1320m628s532m628s532m628s1320m628s532"
      "m628s532m628s532m628s1320m628s1320m628s532m628s1320m628s532m628s532"
      "m628s532m628s1320m628s532m628s1320m628s532m628s1320m628s1320m628s532"
      "m628s532m628s1320m628s1320m628s1320m628s1320m628s532m628s532m628s532"
      "m628s20000"
      "m8532s4228"
      "m628s1320m628s1320m628s1320m628s532m628s1320m628s1320m628s532m628s1320"
      "m628s1320m628s1320m628s532m628s532m628s1320m628s532m628s1320m628s1320"
      "m628s1320m628s532m628s1320m628s532m628s1320m628s532m628s532m628s1320"
      "m628s1320m628s532m628s532m628s532m628s532m628s1320m628s1320m628s1320"
      "m628s20000"
      "m8532s4228"
      "m628s532m628s532m628s532m628s1320m628s532m628s532m628s1320m628s532"
      "m628s532m628s532m628s1320m628s1320m628s532m628s1320m628s532m628s532"
      "m628s532m628s1320m628s532m628s1320m628s532m628s1320m628s1320m628s532"
      "m628s532m628s1320m628s1320m628s1320m628s1320m628s532m628s532m628s532"
      "m628s20000"
      "m8532s4228"
      "m628s532m628s532m628s532m628s1320m628s532m628s532m628s1320m628s532"
      "m628s532m628s532m628s1320m628s1320m628s532m628s1320m628s532m628s532"
      "m628s532m628s1320m628s532m628s1320m628s532m628s1320m628s1320m628s532"
      "m628s532m628s1320m628s1320m628s1320m628s1320m628s532m628s532m628s532"
      "m628s20000"
      "m8532s4228"
      "m628s1320m628s1320m628s1320m628s532m628s1320m628s1320m628s532m628s1320"
      "m628s1320m628s1320m628s532m628s532m628s1320m628s532m628s1320m628s1320"
      "m628s1320m628s532m628s1320m628s532m628s1320m628s532m628s532m628s1320"
      "m628s1320m628s532m628s532m628s532m628s532m628s1320m628s1320m628s1320"
      "m628s20000"
      "m8532s4228"
      "m628s532m628s532m628s532m628s1320m628s532m628s532m628s1320m628s532"
      "m628s532m628s532m628s1320m628s1320m628s532m628s1320m628s532m628s532"
      "m628s532m628s1320m628s532m628s1320m628s532m628s1320m628s1320m628s532"
      "m628s532m628s1320m628s1320m628s1320m628s1320m628s532m628s532m628s532"
      "m628s20000",
      irsend.outputStr());
}

// Tests for decodeCarrierAC().

// Decode normal "synthetic" messages.
TEST(TestDecodeCarrierAC, NormalDecodeWithStrict) {
  IRsendTest irsend(0);
  IRrecv irrecv(0);
  irsend.begin();

  irsend.reset();
  irsend.sendCarrierAC(0x0);
  irsend.makeDecodeResult();
  ASSERT_TRUE(irrecv.decodeCarrierAC(&irsend.capture, kStartOffset,
                                     kCarrierAcBits, true));
  EXPECT_EQ(CARRIER_AC, irsend.capture.decode_type);
  EXPECT_EQ(kCarrierAcBits, irsend.capture.bits);
  EXPECT_EQ(0x0, irsend.capture.value);
  EXPECT_EQ(0x0, irsend.capture.address);
  EXPECT_EQ(0x0, irsend.capture.command);
  EXPECT_FALSE(irsend.capture.repeat);

  irsend.reset();
  irsend.sendCarrierAC(0xB335ABE2);
  irsend.makeDecodeResult();
  ASSERT_TRUE(irrecv.decodeCarrierAC(&irsend.capture, kStartOffset,
                                     kCarrierAcBits, true));
  EXPECT_EQ(CARRIER_AC, irsend.capture.decode_type);
  EXPECT_EQ(kCarrierAcBits, irsend.capture.bits);
  EXPECT_EQ(0xB335ABE2, irsend.capture.value);
  EXPECT_EQ(0xB335, irsend.capture.address);
  EXPECT_EQ(0xABE2, irsend.capture.command);
  EXPECT_FALSE(irsend.capture.repeat);

  // Do the last one again, & use the full decoder, not just protocol specific.
  irsend.reset();
  irsend.sendCarrierAC(0xB335ABE2);
  irsend.makeDecodeResult();
  ASSERT_TRUE(irrecv.decode(&irsend.capture));
  EXPECT_EQ(CARRIER_AC, irsend.capture.decode_type);
  EXPECT_EQ(kCarrierAcBits, irsend.capture.bits);
  EXPECT_EQ(0xB335ABE2, irsend.capture.value);
}

// Decode a "real" example message.
TEST(TestDecodeCarrierAC, RealExamples) {
  IRsendTest irsend(0);
  IRrecv irrecv(0);
  irsend.begin();

  irsend.reset();
  // Data from Issue #385 captured by gnkarn
  uint16_t rawData[203] = {
      8532, 4216, 628, 1312,  628,  528,  628, 1312,  628,  1312, 628, 528,
      628,  524,  628, 1316,  624,  1316, 628, 524,   628,  528,  628, 1312,
      628,  1316, 624, 528,   628,  1312, 628, 528,   628,  1312, 628, 1312,
      628,  528,  628, 1316,  624,  528,  628, 1312,  628,  528,  628, 1312,
      628,  1316, 624, 1316,  628,  1312, 628, 1316,  628,  524,  628, 528,
      628,  528,  624, 1316,  628,  528,  628, 20064, 8504, 4228, 628, 528,
      628,  1312, 628, 528,   628,  528,  628, 1312,  628,  1316, 624, 532,
      624,  528,  628, 1316,  628,  1312, 628, 528,   628,  528,  628, 1312,
      628,  528,  628, 1316,  628,  528,  624, 528,   628,  1316, 628, 528,
      628,  1316, 624, 528,   628,  1316, 628, 528,   624,  532,  624, 528,
      628,  528,  628, 528,   628,  1316, 624, 1316,  628,  1316, 628, 528,
      624,  1316, 628, 20076, 8528, 4212, 624, 1316,  628,  528,  628, 1316,
      628,  1316, 624, 528,   628,  528,  628, 1316,  628,  1316, 628, 528,
      624,  532,  624, 1316,  628,  1316, 628, 528,   628,  1316, 624, 528,
      628,  1316, 628, 1316,  628,  528,  628, 1316,  624,  532,  624, 1316,
      628,  532,  624, 1316,  628,  1316, 624, 1320,  624,  1316, 628, 1316,
      628,  528,  628, 528,   628,  528,  628, 1316,  624,  532,  624};

  irsend.sendRaw(rawData, 203, 38000);
  irsend.makeDecodeResult();
  ASSERT_TRUE(irrecv.decode(&irsend.capture));
  EXPECT_EQ(CARRIER_AC, irsend.capture.decode_type);
  EXPECT_EQ(kCarrierAcBits, irsend.capture.bits);
  EXPECT_EQ(0xB335ABE2, irsend.capture.value);
  EXPECT_EQ(0xB335, irsend.capture.address);
  EXPECT_EQ(0xABE2, irsend.capture.command);
  EXPECT_FALSE(irsend.capture.repeat);
}
