## Платформа
Библиотека компилируется и работает на всех Arduino-совместимых платформах. Для ESP8266 и ESP32 доступны дополнительные сетевые возможности

### ESP8266/ESP32
Библиотека работает на актуальных версиях SDK. Не рекомендуется ставить версии ниже указанных. Ссылки для менеджера плат:
- ESP8266 **v2.7+** https://arduino.esp8266.com/stable/package_esp8266com_index.json
- ESP32 **v2+** https://raw.githubusercontent.com/espressif/arduino-esp32/gh-pages/package_esp32_index.json
    - **НЕ РАБОТАЕТ НА SDK 2.0.8!!!**
    - Если AsyncWebSocket не компилируется на *ESP32C3*: `AsyncWebSocket.cpp` строка ~832 заменить `return IPAddress(0U)` -> `return IPAddress()`

### Если не компилируется
- Удалить Arduino IDE
- Удалить папку Arduino15: `C:\Users\USER\AppData\Local\Arduino15` (Windows)
- Удалить папку с библиотеками: `Документы\Arduino\libraries` (Windows)
- Установить всё актуальных версий

## Установка библиотеки
### GyverHub
Библиотека ещё не вышла в релиз: скачать актуальную бета-версию можно из репозитория - [прямая ссылка на архив](https://github.com/GyverLibs/GyverHub/archive/refs/heads/main.zip). [Документация](https://github.com/GyverLibs/GyverHub/wiki) всегда соответствует текущей версии на гитхаб!

<details>
<summary>Информация из будущего</summary>

- Библиотеку можно найти по названию **GyverHub** и установить через менеджер библиотек в:
    - Arduino IDE
    - Arduino IDE v2
    - PlatformIO
- [Скачать библиотеку](https://github.com/GyverLibs/GyverHub/archive/refs/heads/main.zip) .zip архивом для ручной установки:
    - Распаковать и положить в *Документы/Arduino/libraries/*
    - (Arduino IDE) автоматическая установка из .zip: *Скетч/Подключить библиотеку/Добавить .ZIP библиотеку…* и указать скачанный архив

</details>

- Вручную: распаковать и положить в *Документы/Arduino/libraries/* (Windows)
- Arduino IDE: автоматическая установка из .zip: *Скетч/Подключить библиотеку/Добавить .ZIP библиотеку…* и указать скачанный архив

### Зависимости
Для работы GyverHub нужно установить ещё несколько библиотек:
- Для всех платформ
    - [Stamp](https://github.com/GyverLibs/Stamp), [**СКАЧАТЬ**](https://github.com/GyverLibs/Stamp/archive/refs/heads/main.zip) - *библиотека для работы со временем, устанавливать необязательно*
- Для ESP8266/32
    - Для синхронной работы:
        - [PubSubClient](https://github.com/knolleary/pubsubclient), [**СКАЧАТЬ**](https://github.com/knolleary/pubsubclient/archive/refs/heads/master.zip)
        - [arduinoWebSockets](https://github.com/Links2004/arduinoWebSockets), [**СКАЧАТЬ**](https://github.com/Links2004/arduinoWebSockets/archive/refs/heads/master.zip)
    - Для асинхронной работы:
        - [ESPAsyncWebServer](https://github.com/me-no-dev/ESPAsyncWebServer), [**СКАЧАТЬ**](https://github.com/me-no-dev/ESPAsyncWebServer/archive/refs/heads/master.zip)
        - [ESPAsyncTCP](https://github.com/me-no-dev/ESPAsyncTCP), [**СКАЧАТЬ**](https://github.com/me-no-dev/ESPAsyncTCP/archive/refs/heads/master.zip)
        - [AsyncTCP](https://github.com/me-no-dev/AsyncTCP), [**СКАЧАТЬ**](https://github.com/me-no-dev/AsyncTCP/archive/refs/heads/master.zip)
        - [async-mqtt-client](https://github.com/marvinroger/async-mqtt-client), [**СКАЧАТЬ**](https://github.com/marvinroger/async-mqtt-client/archive/refs/heads/develop.zip)

> Синхронные и асинхронные: в асинхронной версии GyverHub используются библиотеки на базе AsyncTCP. Они "тяжелее", но работают асинхронно и не тормозят работу программы в отличие от синхронных. В то же время на синхронных работа будет более стабильной, по крайней мере мне так показалось.

#### Arduino IDE
Скачать и установить библиотеки как описано выше

#### PlatformIO
Скачать и распаковать библиотеки в папку `lib` проекта или добавить зависимости в *platformio.ini*:

```dosini
lib_deps =
    ;GyverLibs/GyverHub - пока не опубликована
    ;GyverLibs/Stamp - пока не опубликована
    GyverHub=https://github.com/GyverLibs/GyverHub/archive/refs/heads/main.zip
    Stamp=https://github.com/GyverLibs/Stamp/archive/refs/heads/main.zip
    knolleary/PubSubClient
    links2004/WebSockets
    me-no-dev/AsyncTCP
    me-no-dev/ESPAsyncTCP
    me-no-dev/ESP Async WebServer
    marvinroger/AsyncMqttClient
```

## Основные понятия
### Устройство
Под устройством понимается прибор/девайс/самоделка на базе микроконтроллера с программой, включающей библиотеку GyverHub. Для настройки устройства в прогармме нужно указать несколько параметров:
- **Префикс сети** - уникальное имя вашей сети, должно быть одинаковым у всех устройств и у приложения, чтобы они могли общаться друг с другом. С этого префикса также будут начинаться MQTT топики, что позволяет относительно безопасно пользоваться системой даже на публичных MQTT брокерах. *Только английские буквы, цифры, без пробелов*
- **Имя** - название устройства, которое будет отображаться в списке устройств в приложении
- **Иконка** - иконка рядом с названием в списке устройств. Иконки *Font Awesome v5 Solid Free*:
    - [Поиск иконок](https://fontawesome.com/v5/search?o=r&m=free&s=solid)

### WS (WebSocket)
WebSocket - это сетевой протокол связи, в рамках системы GyverHub используется для связи устройства и приложения в локальной сети, т.е. без использования связи с Интернет:
- Устройство и смартфон/компьютер подключены к одному роутеру
- Смартфон/компьютер подключен к устройству, работающему как точка доступа

### MQTT
MQTT позволяет управлять своим устройством через интернет (из другого города или любой другой точки планеты). GyverHub работает с внешним брокером. Для использования MQTT нужно выбрать брокера и указать хост (или его IP адрес) и порт, опционально логин + пароль, см. документацию. Требования к MQTT брокеру:
- Наличие *Wildcards* (топики с `/#`)
- Наличие незащищённого TCP (для устройства)
- Наличие Websocket с TLS (для приложения)
- Лично я пользуюсь [WQTT](https://www.wqtt.ru/) - 300 рублей в год + интеграция с Алисой
- [Список бесплатных брокеров](https://kotyara12.ru/iot/cloud_services/)
- Для экспериментов можно использовать бесплатный публичный [mosquitto](https://test.mosquitto.org/), он настроен в примерах по умолчанию:
  - Хост: `test.mosquitto.org`
  - Порт (esp): `1883`
  - Порт (приложение): `8081`

> Примечание: если оставить стандартный префикс и брокера из примера ниже - можно найти и потыкать мои тестовые устройства

> Пароль от MQTT, как и все остальные настройки сайта/приложения, хранится исключительно в браузере, т.е. в памяти компьютера/смартфона (Local storage)

## Минимальный код
```cpp
#include <GyverHub.h>
GyverHub hub("MyDevices", "ESP8266", "");  // префикс, имя, иконка

// билдер
void build() {
}

void setup() {
    // Serial.begin(115200);
    // подключение к WiFi...
    // настройка MQTT
    //hub.setupMQTT("test.mosquitto.org", 1883);
    //hub.setupMQTT("m8.wqtt.ru", 13448, "****", "****");

    hub.onBuild(build);     // подключаем билдер
    hub.begin();            // запускаем систему
}

void loop() {
    hub.tick();  // обязательно тикаем тут
}
```

Для подключения к WiFi роутеру можно использовать стандартный код:
```cpp
WiFi.mode(WIFI_STA);
WiFi.begin("SSID", "PASS");
while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
}
```

Система может работать локально (в режиме WS), для этого нужно запустить esp в режиме точки доступа
```cpp
WiFi.mode(WIFI_AP);
WiFi.softAP("My Device");
```

Всё готово, устройство уже можно найти из приложения!

## Настройка сайта/приложения
- Нажать шестерёнку справа
- Ввести свой префикс сети в блоке Settings

### Поиск устройств
Нажать лупу в самом первом пункте настроек, устройство должно появиться в списке

![image](https://user-images.githubusercontent.com/84599917/236940953-c5d64dd3-6302-4839-8fc2-58fdb666357b.png)  
![image](https://user-images.githubusercontent.com/84599917/236945607-75249359-33ac-4935-a741-edf7cca7ab03.png)  

- `W` - устройство доступно в локальной сети по Websocket
- `M` - устройство доступно через Интернет по MQTT
- `S` - Serial
- `B` - Bluetooth

> Приоритет: устройство откроется в том подключении, чья буква расположена левее (приоритет S, B, W, M)

### MQTT
Настройка для сервиса WQTT  
![image](https://user-images.githubusercontent.com/84599917/236941720-0dbe174f-dc7e-43cf-bb46-38c7d902a30c.png)  