/*
    Менеджер FS - библиотека для хранения данных в файловой системе
    Версии:
    v1.0 - релиз
*/


#define USE_LittleFS  // Закомментируйте эту строку, если вместо файловой системы LittlFS  хотите использовать файловую систему SPIFFS
#ifdef USE_LittleFS
#include <LittleFS.h>    
#define SPIFFS LittleFS  
#endif

bool success;

class FSManager {
public:
    // передать данные любого типа, опционально таймаут обновления в мс
    template <typename T> FSManager(T &data, String fileName="", uint16_t tout = 5000) {
        _data = (uint8_t*)&data;
        _size = sizeof(T);
        _tout = tout;
        _fileName = fileName;
    }
    
    // сменить таймаут
    void setTimeout(uint16_t tout = 5000) {
        _tout = tout;
    }
    void setFilename(String fileName) {
        _fileName = fileName;
    }
    void init() {
      success = SPIFFS.begin();
    }

    // начать работу, прочитать данные из файла в переменную. 
    uint8_t begin() {        
        File configFile = SPIFFS.open("/" + _fileName, "r");
        if (!configFile) { 
           updateNow();
           return 1;
        } else 
        if (configFile.size()!=_size) {
           updateNow();
           return 1;
        } else {
           configFile.read(_data,_size);
           configFile.close();
           return 0;
        }
    }
    
    // обновить данные в файле сейчас
    void updateNow() {
         File configFile = SPIFFS.open("/" + _fileName, "w");
         configFile.write(_data,_size);
         configFile.close();
    }
    
    // отложить обновление и сбросить таймер
    void update() {
        _tmr = millis();
        _update = 1;
    }
    
    // тикер обновления
    bool tick() {
        if (_update && millis() - _tmr >= _tout) {
            updateNow();
            _update = 0;
            return 1;
        } return 0;
    }
    
   
    // получить размер данных
    uint16_t dataSize() {
        return _size;
    }
    
    
private:
    uint8_t* _data;
    uint16_t _size, _addr;
    bool _ready = 0, _update = 0;
    uint32_t _tmr = 0;
    uint16_t _tout;
    String _fileName;
};
