#define MAX_ALARMS 16
#define RELE_PIN              (0U)         // GPIO0 Реле
#define ESP_UDP_PORT          (8888U)      // номер порта, который будет "слушать" UDP сервер во время работы лампы как в режиме WiFi точки доступа, так и в режиме WiFi клиента (лучше не менять)
#define MAX_UDP_BUFFER_SIZE   (255U)       // максимальный размер буффера UDP сервера
//#define IP_STATIC                        // Если нужен статический IP, раскоментируйте

#if defined (IP_STATIC)
IPAddress ip(192,168,100,102);  //Node static IP
IPAddress gateway(192,168,100,1);
IPAddress subnet(255,255,255,0);
#endif

// Значения переменных на FS диске в виде файлов
FSManager FSwifi(portalCfg,"wifi.dat");

//заглушка для приложения управления лампами
#define DISCOVER "IP %d.%d.%d.%d:%d:G220_FS"

char packetBuffer[MAX_UDP_BUFFER_SIZE];                     // buffer to hold incoming packet
char inputBuffer[MAX_UDP_BUFFER_SIZE];

GyverHub hub("MyDevices", "G220_FS", "⚡");

uint16_t localPort = ESP_UDP_PORT;

WiFiUDP Udp;
WiFiUDP ntpUDP;

int hour = 1;
int minute = 0;
int dayofweek=0;

uint64_t ntp_update_time=0;
const long utcOffsetInSeconds = 10800;

NTPClient timeClient(ntpUDP, "pool.ntp.org", utcOffsetInSeconds);
bool eeprom_flag=false;
bool copy_to_all=true;

//--------------------------
struct struct_alarm{
  bool on_off=false;
  uint32_t alarm_time=0;
  uint8_t cmd=0;
  GHflags flags=0;
  bool ok=true;
};

struct_alarm alarms[MAX_ALARMS];
FSManager EE_alarms(alarms,"alarms.dat");
bool rele=false;
