#include <WiFiUdp.h>
#include <NTPClient.h>
#include <GyverHub.h>
#include <Stamp.h>
#include <FSManager.h>
#include <SimplePortal.h>

#include "macros.h"            //Список макросов
#include "define.h"            //Настройки и переменные


void setup() {
#ifdef DEBUG_SERIAL_GT
  Serial.begin(115200);
#endif

  success = SPIFFS.begin(); // подключаем файловую систему 

  Connect_WiFi_Portal();    // ищем сеть WiFi
  // Время
  timeClient.begin();
  delay(500);
  timeClient.update(); 
  hour   = timeClient.getHours();
  minute = timeClient.getMinutes();
  Udp.begin(localPort);
  hub.onBuild(build);     // подключаем билдер
  hub.begin();            // запускаем систему
  byte stat;

  stat=EE_alarms.begin();
  pinMode(RELE_PIN,OUTPUT);
  rele=false;
  digitalWrite(RELE_PIN,not rele);
 
}


void loop() {
  hub.tick();  // обязательно тикаем тут
  // Разные таймеры
  usertimeClientupdate();
  userTimeRead();
  userWiFiReconect();
  userAutoSave();
  test_alarms();
  parseUDP();
  digitalWrite(RELE_PIN,not rele);
}
